/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.TopUpRequestedMoneyProvided;

@JsonClass(generateAdapter=false)
public class TopUpRequestedMoneyProvidedImpl
implements TopUpRequestedMoneyProvided {
    private final Money moneyProvided;
    private final Optional<CurrencyCode> currencyRequired;
    private final int hashCode;
    private final String toString;

    @Override
    public Money getMoneyProvided() {
        return this.moneyProvided;
    }

    @Override
    public Optional<CurrencyCode> getCurrencyRequired() {
        return this.currencyRequired;
    }

    private TopUpRequestedMoneyProvidedImpl(BuilderImpl builder) {
        this.moneyProvided = Objects.requireNonNull(builder.moneyProvided, "Property 'moneyProvided' is required.");
        this.currencyRequired = Optional.ofNullable(builder.currencyRequired);
        this.hashCode = Objects.hash(this.moneyProvided, this.currencyRequired);
        this.toString = builder.type + "(moneyProvided=" + this.moneyProvided + ", currencyRequired=" + this.currencyRequired + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopUpRequestedMoneyProvidedImpl)) {
            return false;
        }
        TopUpRequestedMoneyProvidedImpl that = (TopUpRequestedMoneyProvidedImpl)obj;
        if (!Objects.equals(this.moneyProvided, that.moneyProvided)) {
            return false;
        }
        return Objects.equals(this.currencyRequired, that.currencyRequired);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements TopUpRequestedMoneyProvided.Builder {
        private Money moneyProvided = null;
        private CurrencyCode currencyRequired = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("TopUpRequestedMoneyProvided");
        }

        @Override
        public BuilderImpl moneyProvided(Money moneyProvided) {
            this.moneyProvided = moneyProvided;
            return this;
        }

        @Override
        public boolean isMoneyProvidedDefined() {
            return this.moneyProvided != null;
        }

        @Override
        public BuilderImpl currencyRequired(CurrencyCode currencyRequired) {
            this.currencyRequired = currencyRequired;
            return this;
        }

        @Override
        public boolean isCurrencyRequiredDefined() {
            return this.currencyRequired != null;
        }

        @Override
        public TopUpRequestedMoneyProvidedImpl build() {
            return new TopUpRequestedMoneyProvidedImpl(this);
        }
    }
}

