/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountResponseP2AV2;
import tech.carpentum.sdk.payment.model.ExternalReference;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.P2AV2MethodResponse;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentAddress;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public class P2AV2MethodResponseImpl
implements P2AV2MethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final AccountResponseP2AV2 account;
    private final MoneyPaymentResponse money;
    private final Optional<MoneyVat> vat;
    private final String merchantName;
    private final PaymentAddress paymentAddress;
    private final String qrName;
    private final String qrCode;
    private final String reference;
    private final Optional<ExternalReference> externalReference;
    private final String returnUrl;
    private final PaymentOperatorIncoming paymentOperator;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public AccountResponseP2AV2 getAccount() {
        return this.account;
    }

    @Override
    public MoneyPaymentResponse getMoney() {
        return this.money;
    }

    @Override
    public Optional<MoneyVat> getVat() {
        return this.vat;
    }

    @Override
    public String getMerchantName() {
        return this.merchantName;
    }

    @Override
    public PaymentAddress getPaymentAddress() {
        return this.paymentAddress;
    }

    @Override
    public String getQrName() {
        return this.qrName;
    }

    @Override
    public String getQrCode() {
        return this.qrCode;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public Optional<ExternalReference> getExternalReference() {
        return this.externalReference;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public PaymentOperatorIncoming getPaymentOperator() {
        return this.paymentOperator;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private P2AV2MethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.vat = Optional.ofNullable(builder.vat);
        this.merchantName = Objects.requireNonNull(builder.merchantName, "Property 'merchantName' is required.");
        this.paymentAddress = Objects.requireNonNull(builder.paymentAddress, "Property 'paymentAddress' is required.");
        this.qrName = Objects.requireNonNull(builder.qrName, "Property 'qrName' is required.");
        this.qrCode = Objects.requireNonNull(builder.qrCode, "Property 'qrCode' is required.");
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.externalReference = Optional.ofNullable(builder.externalReference);
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.paymentOperator = Objects.requireNonNull(builder.paymentOperator, "Property 'paymentOperator' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.account, this.money, this.vat, this.merchantName, this.paymentAddress, this.qrName, this.qrCode, this.reference, this.externalReference, this.returnUrl, this.paymentOperator, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", account=" + this.account + ", money=" + this.money + ", vat=" + this.vat + ", merchantName=" + this.merchantName + ", paymentAddress=" + this.paymentAddress + ", qrName=" + this.qrName + ", qrCode=" + this.qrCode + ", reference=" + this.reference + ", externalReference=" + this.externalReference + ", returnUrl=" + this.returnUrl + ", paymentOperator=" + this.paymentOperator + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof P2AV2MethodResponseImpl)) {
            return false;
        }
        P2AV2MethodResponseImpl that = (P2AV2MethodResponseImpl)obj;
        if (!Objects.equals(this.idPayin, that.idPayin)) {
            return false;
        }
        if (!Objects.equals(this.idPayment, that.idPayment)) {
            return false;
        }
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.vat, that.vat)) {
            return false;
        }
        if (!Objects.equals(this.merchantName, that.merchantName)) {
            return false;
        }
        if (!Objects.equals(this.paymentAddress, that.paymentAddress)) {
            return false;
        }
        if (!Objects.equals(this.qrName, that.qrName)) {
            return false;
        }
        if (!Objects.equals(this.qrCode, that.qrCode)) {
            return false;
        }
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        if (!Objects.equals(this.externalReference, that.externalReference)) {
            return false;
        }
        if (!Objects.equals(this.returnUrl, that.returnUrl)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperator, that.paymentOperator)) {
            return false;
        }
        if (!Objects.equals(this.acceptedAt, that.acceptedAt)) {
            return false;
        }
        return Objects.equals(this.expireAt, that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements P2AV2MethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private AccountResponseP2AV2 account = null;
        private MoneyPaymentResponse money = null;
        private MoneyVat vat = null;
        private String merchantName = null;
        private PaymentAddress paymentAddress = null;
        private String qrName = null;
        private String qrCode = null;
        private String reference = null;
        private ExternalReference externalReference = null;
        private String returnUrl = null;
        private PaymentOperatorIncoming paymentOperator = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("P2AV2MethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public boolean isIdPayinDefined() {
            return this.idPayin != null;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public boolean isIdPaymentDefined() {
            return this.idPayment != null;
        }

        @Override
        public BuilderImpl account(AccountResponseP2AV2 account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl money(MoneyPaymentResponse money) {
            this.money = money;
            return this;
        }

        @Override
        public boolean isMoneyDefined() {
            return this.money != null;
        }

        @Override
        public BuilderImpl vat(MoneyVat vat) {
            this.vat = vat;
            return this;
        }

        @Override
        public boolean isVatDefined() {
            return this.vat != null;
        }

        @Override
        public BuilderImpl merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @Override
        public boolean isMerchantNameDefined() {
            return this.merchantName != null;
        }

        @Override
        public BuilderImpl paymentAddress(PaymentAddress paymentAddress) {
            this.paymentAddress = paymentAddress;
            return this;
        }

        @Override
        public boolean isPaymentAddressDefined() {
            return this.paymentAddress != null;
        }

        @Override
        public BuilderImpl qrName(String qrName) {
            this.qrName = qrName;
            return this;
        }

        @Override
        public boolean isQrNameDefined() {
            return this.qrName != null;
        }

        @Override
        public BuilderImpl qrCode(String qrCode) {
            this.qrCode = qrCode;
            return this;
        }

        @Override
        public boolean isQrCodeDefined() {
            return this.qrCode != null;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public boolean isReferenceDefined() {
            return this.reference != null;
        }

        @Override
        public BuilderImpl externalReference(ExternalReference externalReference) {
            this.externalReference = externalReference;
            return this;
        }

        @Override
        public boolean isExternalReferenceDefined() {
            return this.externalReference != null;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public boolean isReturnUrlDefined() {
            return this.returnUrl != null;
        }

        @Override
        public BuilderImpl paymentOperator(PaymentOperatorIncoming paymentOperator) {
            this.paymentOperator = paymentOperator;
            return this;
        }

        @Override
        public boolean isPaymentOperatorDefined() {
            return this.paymentOperator != null;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public boolean isAcceptedAtDefined() {
            return this.acceptedAt != null;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public boolean isExpireAtDefined() {
            return this.expireAt != null;
        }

        @Override
        public P2AV2MethodResponseImpl build() {
            return new P2AV2MethodResponseImpl(this);
        }
    }
}

