/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AbsaPayMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountCallbackAbsaPay;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseAbsaPay;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public interface AbsaPayMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.ABSA_PAY;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public @NotNull List<@NotNull AccountCallbackAbsaPay> getAccounts();

    @NotNull
    public AccountCustomerResponseAbsaPay getAccountCustomer();

    @NotNull
    public MoneyPaymentResponse getMoney();

    @NotNull
    public Optional<MoneyVat> getVat();

    @NotNull
    public String getReference();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(AbsaPayMethodResponse copyOf) {
        Builder builder = AbsaPayMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.accounts(copyOf.getAccounts());
        builder.accountCustomer(copyOf.getAccountCustomer());
        builder.money(copyOf.getMoney());
        builder.vat(copyOf.getVat().orElse(null));
        builder.reference(copyOf.getReference());
        builder.returnUrl(copyOf.getReturnUrl());
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new AbsaPayMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        @NotNull
        public Builder idPayment(IdPayment var1);

        @NotNull
        public Builder accounts(List<@NotNull AccountCallbackAbsaPay> var1);

        @NotNull
        public Builder accountsAdd(AccountCallbackAbsaPay var1);

        @NotNull
        public Builder accountsAddAll(List<@NotNull AccountCallbackAbsaPay> var1);

        @NotNull
        public Builder accountCustomer(AccountCustomerResponseAbsaPay var1);

        @NotNull
        public Builder money(MoneyPaymentResponse var1);

        @NotNull
        public Builder vat(MoneyVat var1);

        @NotNull
        public Builder reference(String var1);

        @NotNull
        public Builder returnUrl(String var1);

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        @NotNull
        public AbsaPayMethodResponse build();
    }
}

