/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseMobileMoney;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MobileMoneyMethodResponse;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public class MobileMoneyMethodResponseImpl
implements MobileMoneyMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final AccountCustomerResponseMobileMoney accountCustomer;
    private final MoneyPaymentResponse money;
    private final Optional<MoneyVat> vat;
    private final String merchantName;
    private final Optional<String> phoneNumber;
    private final String reference;
    private final String returnUrl;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public AccountCustomerResponseMobileMoney getAccountCustomer() {
        return this.accountCustomer;
    }

    @Override
    public MoneyPaymentResponse getMoney() {
        return this.money;
    }

    @Override
    public Optional<MoneyVat> getVat() {
        return this.vat;
    }

    @Override
    public String getMerchantName() {
        return this.merchantName;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private MobileMoneyMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.accountCustomer = Objects.requireNonNull(builder.accountCustomer, "Property 'accountCustomer' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.vat = Optional.ofNullable(builder.vat);
        this.merchantName = Objects.requireNonNull(builder.merchantName, "Property 'merchantName' is required.");
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.accountCustomer, this.money, this.vat, this.merchantName, this.phoneNumber, this.reference, this.returnUrl, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", accountCustomer=" + this.accountCustomer + ", money=" + this.money + ", vat=" + this.vat + ", merchantName=" + this.merchantName + ", phoneNumber=" + this.phoneNumber + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MobileMoneyMethodResponseImpl)) {
            return false;
        }
        MobileMoneyMethodResponseImpl that = (MobileMoneyMethodResponseImpl)obj;
        if (!Objects.equals(this.idPayin, that.idPayin)) {
            return false;
        }
        if (!Objects.equals(this.idPayment, that.idPayment)) {
            return false;
        }
        if (!Objects.equals(this.accountCustomer, that.accountCustomer)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.vat, that.vat)) {
            return false;
        }
        if (!Objects.equals(this.merchantName, that.merchantName)) {
            return false;
        }
        if (!Objects.equals(this.phoneNumber, that.phoneNumber)) {
            return false;
        }
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        if (!Objects.equals(this.returnUrl, that.returnUrl)) {
            return false;
        }
        if (!Objects.equals(this.acceptedAt, that.acceptedAt)) {
            return false;
        }
        return Objects.equals(this.expireAt, that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements MobileMoneyMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private AccountCustomerResponseMobileMoney accountCustomer = null;
        private MoneyPaymentResponse money = null;
        private MoneyVat vat = null;
        private String merchantName = null;
        private String phoneNumber = null;
        private String reference = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("MobileMoneyMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public BuilderImpl accountCustomer(AccountCustomerResponseMobileMoney accountCustomer) {
            this.accountCustomer = accountCustomer;
            return this;
        }

        @Override
        public BuilderImpl money(MoneyPaymentResponse money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl vat(MoneyVat vat) {
            this.vat = vat;
            return this;
        }

        @Override
        public BuilderImpl merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public MobileMoneyMethodResponseImpl build() {
            return new MobileMoneyMethodResponseImpl(this);
        }
    }
}

