/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.io.InterruptedIOException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.EndpointWithIdDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.EnhancedOutgoingPaymentsApi;
import tech.carpentum.sdk.payment.internal.api.GetPayoutErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.PostAvailablePayoutOptionsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.PostPayoutsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.AvailablePayoutOptionList;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.Payout;
import tech.carpentum.sdk.payment.model.PayoutAccepted;
import tech.carpentum.sdk.payment.model.PayoutDetail;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltech/carpentum/sdk/payment/OutgoingPaymentsApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedOutgoingPaymentsApi;", "<init>", "(ILtech/carpentum/sdk/payment/internal/api/EnhancedOutgoingPaymentsApi;)V", "availablePaymentOptions", "Ltech/carpentum/sdk/payment/model/AvailablePayoutOptionList;", "paymentRequested", "Ltech/carpentum/sdk/payment/model/PaymentRequested;", "createPayout", "Ltech/carpentum/sdk/payment/model/PayoutAccepted;", "idPayout", "", "payout", "Ltech/carpentum/sdk/payment/model/Payout;", "getPayout", "Ltech/carpentum/sdk/payment/model/PayoutDetail;", "Factory", "payment-client-v2"})
public final class OutgoingPaymentsApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    private final int apiVersion;
    @NotNull
    private final EnhancedOutgoingPaymentsApi api;

    private OutgoingPaymentsApi(int apiVersion, EnhancedOutgoingPaymentsApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @NotNull
    public final AvailablePayoutOptionList availablePaymentOptions(@NotNull PaymentRequested paymentRequested) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)paymentRequested, (String)"paymentRequested");
        return (AvailablePayoutOptionList)ResponseExceptionUtils.INSTANCE.wrap(PostAvailablePayoutOptionsErrorExceptionFactory.Companion.getInstance(), () -> OutgoingPaymentsApi.availablePaymentOptions$lambda$0(this, paymentRequested));
    }

    @NotNull
    public final PayoutAccepted createPayout(@NotNull String idPayout, @NotNull Payout payout) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)idPayout, (String)"idPayout");
        Intrinsics.checkNotNullParameter((Object)payout, (String)"payout");
        return (PayoutAccepted)ResponseExceptionUtils.INSTANCE.wrap(PostPayoutsErrorExceptionFactory.Companion.getInstance(), () -> OutgoingPaymentsApi.createPayout$lambda$1(this, idPayout, payout));
    }

    @NotNull
    public final PayoutDetail getPayout(@NotNull String idPayout) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)idPayout, (String)"idPayout");
        return (PayoutDetail)ResponseExceptionUtils.INSTANCE.wrap(GetPayoutErrorExceptionFactory.Companion.getInstance(), () -> OutgoingPaymentsApi.getPayout$lambda$2(this, idPayout));
    }

    private static final AvailablePayoutOptionList availablePaymentOptions$lambda$0(OutgoingPaymentsApi this$0, PaymentRequested $paymentRequested) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$paymentRequested, (String)"$paymentRequested");
        return this$0.api.payoutAvailablePaymentOptions(this$0.apiVersion, $paymentRequested);
    }

    private static final PayoutAccepted createPayout$lambda$1(OutgoingPaymentsApi this$0, String $idPayout, Payout $payout) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$idPayout, (String)"$idPayout");
        Intrinsics.checkNotNullParameter((Object)$payout, (String)"$payout");
        return this$0.api.createPayout(this$0.apiVersion, $idPayout, $payout);
    }

    private static final PayoutDetail getPayout$lambda$2(OutgoingPaymentsApi this$0, String $idPayout) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$idPayout, (String)"$idPayout");
        return this$0.api.getPayout(this$0.apiVersion, $idPayout);
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineAvailablePaymentOptionsEndpoint() {
        return Factory.defineAvailablePaymentOptionsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineCreatePayoutEndpoint() {
        return Factory.defineCreatePayoutEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineGetPayoutEndpoint() {
        return Factory.defineGetPayoutEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OutgoingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OutgoingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public /* synthetic */ OutgoingPaymentsApi(int apiVersion, EnhancedOutgoingPaymentsApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Ltech/carpentum/sdk/payment/OutgoingPaymentsApi$Factory;", "", "<init>", "()V", "defineAvailablePaymentOptionsEndpoint", "Ltech/carpentum/sdk/payment/EndpointDefinition;", "defineCreatePayoutEndpoint", "Ltech/carpentum/sdk/payment/EndpointWithIdDefinition;", "defineGetPayoutEndpoint", "create", "Ltech/carpentum/sdk/payment/OutgoingPaymentsApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineAvailablePaymentOptionsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.POST, "/payouts/!availablePaymentOptions");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineCreatePayoutEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.POST, "/payouts/{id}");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineGetPayoutEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.GET, "/payouts/{id}");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OutgoingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            int n = context.getApiVersion();
            String string = context.getApiBaseUrl();
            String string2 = context.getBrand();
            Duration duration = callTimeout;
            if (duration == null) {
                duration = context.getDefaultCallTimeout();
            }
            return new OutgoingPaymentsApi(n, new EnhancedOutgoingPaymentsApi(string, accessToken, string2, duration), null);
        }

        public static /* synthetic */ OutgoingPaymentsApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OutgoingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.OutgoingPaymentsApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

