/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.io.InterruptedIOException;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.EnhancedAuthApi;
import tech.carpentum.sdk.payment.internal.api.PostAuthTokensErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.AuthTokenRequest;
import tech.carpentum.sdk.payment.model.AuthTokenResponse;
import tech.carpentum.sdk.payment.model.Money;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()BC\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0002J2\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0007J8\u0010\u001f\u001a\u00020 2\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\"0'2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\n2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\b\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0013\u0010\t\u001a\u00020\n\u00a2\u0006\n\n\u0002\b\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u000b\u001a\u00020\n\u00a2\u0006\n\n\u0002\b\u001a\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ltech/carpentum/sdk/payment/PaymentContext;", "", "apiBaseUrl", "", "apiVersion", "", "merchantCode", "brand", "secret", "defaultTokenValidity", "Ljava/time/Duration;", "defaultCallTimeout", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;)V", "getApiBaseUrl", "()Ljava/lang/String;", "getApiVersion", "()I", "apiVersion$1", "getMerchantCode", "getBrand", "getSecret", "getDefaultTokenValidity", "()Ljava/time/Duration;", "defaultTokenValidity$1", "getDefaultCallTimeout", "defaultCallTimeout$1", "authApi", "Ltech/carpentum/sdk/payment/internal/api/EnhancedAuthApi;", "validityInSeconds", "tokenValidity", "createAuthToken", "Ltech/carpentum/sdk/payment/model/AuthTokenResponse;", "operations", "", "money", "Ljava/util/Optional;", "Ltech/carpentum/sdk/payment/model/Money;", "operationsSupplier", "Ljava/util/function/Supplier;", "Factory", "Builder", "payment-client-v2"})
public final class PaymentContext {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final String apiBaseUrl;
    private final int apiVersion$1;
    @NotNull
    private final String merchantCode;
    @Nullable
    private final String brand;
    @NotNull
    private final String secret;
    @NotNull
    private final Duration defaultTokenValidity$1;
    @NotNull
    private final Duration defaultCallTimeout$1;
    @NotNull
    private final EnhancedAuthApi authApi;
    @NotNull
    public static final String ENV_TECH_CARPENTUM_SDK_PAYMENT_DOMAIN = "TECH_CARPENTUM_SDK_PAYMENT_DOMAIN";
    @NotNull
    public static final String ENV_TECH_CARPENTUM_SDK_PAYMENT_API_BASE_URL = "TECH_CARPENTUM_SDK_PAYMENT_API_BASE_URL";
    @NotNull
    public static final String ENV_TECH_CARPENTUM_SDK_PAYMENT_MERCHANT_CODE = "TECH_CARPENTUM_SDK_PAYMENT_MERCHANT_CODE";
    @NotNull
    public static final String ENV_TECH_CARPENTUM_SDK_PAYMENT_SECRET = "TECH_CARPENTUM_SDK_PAYMENT_SECRET";
    @NotNull
    public static final String ENV_TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT = "TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT";
    private static final int apiVersion = 2;
    @NotNull
    private static final String apiBaseUrlPrefix = "https://api.";
    @NotNull
    private static final Duration defaultTokenValidity;
    @NotNull
    private static final Duration defaultCallTimeout;

    private PaymentContext(String apiBaseUrl2, int apiVersion, String merchantCode, String brand, String secret, Duration defaultTokenValidity, Duration defaultCallTimeout) {
        this.apiBaseUrl = apiBaseUrl2;
        this.apiVersion$1 = apiVersion;
        this.merchantCode = merchantCode;
        this.brand = brand;
        this.secret = secret;
        this.defaultTokenValidity$1 = defaultTokenValidity;
        this.defaultCallTimeout$1 = defaultCallTimeout;
        this.authApi = new EnhancedAuthApi(this.apiBaseUrl, this.defaultCallTimeout$1);
    }

    @NotNull
    public final String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public final int getApiVersion() {
        return this.apiVersion$1;
    }

    @NotNull
    public final String getMerchantCode() {
        return this.merchantCode;
    }

    @Nullable
    public final String getBrand() {
        return this.brand;
    }

    @NotNull
    public final String getSecret() {
        return this.secret;
    }

    @NotNull
    public final Duration getDefaultTokenValidity() {
        return this.defaultTokenValidity$1;
    }

    @NotNull
    public final Duration getDefaultCallTimeout() {
        return this.defaultCallTimeout$1;
    }

    private final int validityInSeconds(Duration tokenValidity) {
        Duration duration = tokenValidity;
        if (duration == null) {
            duration = this.defaultTokenValidity$1;
        }
        return (int)duration.getSeconds();
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull List<String> operations, @Nullable Duration tokenValidity, @NotNull Optional<Money> money) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        Intrinsics.checkNotNullParameter(money, (String)"money");
        int validityInSeconds = this.validityInSeconds(tokenValidity);
        AuthTokenRequest.Builder builder = AuthTokenRequest.builder().merchantCode(this.merchantCode).secret(this.secret).validitySecs(validityInSeconds).operations(operations);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"operations(...)");
        AuthTokenRequest.Builder requestBodyBuilder = builder;
        money.ifPresent(arg_0 -> PaymentContext.createAuthToken$lambda$1(arg_0 -> PaymentContext.createAuthToken$lambda$0(requestBodyBuilder, arg_0), arg_0));
        AuthTokenRequest authTokenRequest = requestBodyBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)authTokenRequest, (String)"build(...)");
        AuthTokenRequest requestBody = authTokenRequest;
        return (AuthTokenResponse)ResponseExceptionUtils.INSTANCE.wrap(PostAuthTokensErrorExceptionFactory.Companion.getInstance(), () -> PaymentContext.createAuthToken$lambda$2(this, requestBody));
    }

    public static /* synthetic */ AuthTokenResponse createAuthToken$default(PaymentContext paymentContext, List list, Duration duration, Optional optional, int n, Object object) throws ResponseException, InterruptedIOException {
        if ((n & 2) != 0) {
            duration = null;
        }
        if ((n & 4) != 0) {
            optional = Optional.empty();
        }
        return paymentContext.createAuthToken(list, duration, optional);
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull Supplier<List<String>> operationsSupplier, @Nullable Duration tokenValidity, @NotNull Optional<Money> money) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter(operationsSupplier, (String)"operationsSupplier");
        Intrinsics.checkNotNullParameter(money, (String)"money");
        List<String> list = operationsSupplier.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        return this.createAuthToken(list, tokenValidity, money);
    }

    public static /* synthetic */ AuthTokenResponse createAuthToken$default(PaymentContext paymentContext, Supplier supplier, Duration duration, Optional optional, int n, Object object) throws ResponseException, InterruptedIOException {
        if ((n & 2) != 0) {
            duration = null;
        }
        if ((n & 4) != 0) {
            optional = Optional.empty();
        }
        return paymentContext.createAuthToken(supplier, duration, optional);
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull List<String> operations, @Nullable Duration tokenValidity) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        return PaymentContext.createAuthToken$default(this, operations, tokenValidity, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull List<String> operations) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        return PaymentContext.createAuthToken$default(this, operations, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull Supplier<List<String>> operationsSupplier, @Nullable Duration tokenValidity) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter(operationsSupplier, (String)"operationsSupplier");
        return PaymentContext.createAuthToken$default(this, operationsSupplier, tokenValidity, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull Supplier<List<String>> operationsSupplier) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter(operationsSupplier, (String)"operationsSupplier");
        return PaymentContext.createAuthToken$default(this, operationsSupplier, null, null, 6, null);
    }

    private static final Unit createAuthToken$lambda$0(AuthTokenRequest.Builder $requestBodyBuilder, Money moneyRequest) {
        Intrinsics.checkNotNullParameter((Object)$requestBodyBuilder, (String)"$requestBodyBuilder");
        Intrinsics.checkNotNullParameter((Object)moneyRequest, (String)"moneyRequest");
        $requestBodyBuilder.money(moneyRequest);
        return Unit.INSTANCE;
    }

    private static final void createAuthToken$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final AuthTokenResponse createAuthToken$lambda$2(PaymentContext this$0, AuthTokenRequest $requestBody) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$requestBody, (String)"$requestBody");
        return this$0.authApi.createAuthToken(this$0.apiVersion$1, $requestBody);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Factory.builder();
    }

    public static final /* synthetic */ Duration access$getDefaultTokenValidity$cp() {
        return defaultTokenValidity;
    }

    public /* synthetic */ PaymentContext(String apiBaseUrl2, int apiVersion, String merchantCode, String brand, String secret, Duration defaultTokenValidity, Duration defaultCallTimeout, DefaultConstructorMarker $constructor_marker) {
        this(apiBaseUrl2, apiVersion, merchantCode, brand, secret, defaultTokenValidity, defaultCallTimeout);
    }

    static {
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        defaultTokenValidity = duration;
        Duration duration2 = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        defaultCallTimeout = duration2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltech/carpentum/sdk/payment/PaymentContext$Builder;", "", "<init>", "()V", "apiBaseUrl", "", "merchantCode", "brand", "secret", "defaultTokenValidity", "Ljava/time/Duration;", "defaultCallTimeout", "formatApiBaseUrl", "domain", "tokenValidity", "callTimeout", "build", "Ltech/carpentum/sdk/payment/PaymentContext;", "payment-client-v2"})
    @SourceDebugExtension(value={"SMAP\nPaymentContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentContext.kt\ntech/carpentum/sdk/payment/PaymentContext$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
    public static final class Builder {
        @Nullable
        private String apiBaseUrl = Optional.ofNullable(System.getenv("TECH_CARPENTUM_SDK_PAYMENT_API_BASE_URL")).orElseGet(() -> Builder.apiBaseUrl$lambda$1(this));
        @Nullable
        private String merchantCode = System.getenv("TECH_CARPENTUM_SDK_PAYMENT_MERCHANT_CODE");
        @Nullable
        private String brand;
        @Nullable
        private String secret = System.getenv("TECH_CARPENTUM_SDK_PAYMENT_SECRET");
        @NotNull
        private Duration defaultTokenValidity = PaymentContext.access$getDefaultTokenValidity$cp();
        @NotNull
        private Duration defaultCallTimeout;

        public Builder() {
            Duration duration = Optional.ofNullable(System.getenv(PaymentContext.ENV_TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT)).map(arg_0 -> Builder.defaultCallTimeout$lambda$3(Builder::defaultCallTimeout$lambda$2, arg_0)).map(arg_0 -> Builder.defaultCallTimeout$lambda$5(Builder::defaultCallTimeout$lambda$4, arg_0)).orElseGet(Builder::defaultCallTimeout$lambda$6);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"orElseGet(...)");
            this.defaultCallTimeout = duration;
        }

        private final String formatApiBaseUrl(String domain) {
            return PaymentContext.apiBaseUrlPrefix + domain;
        }

        @NotNull
        public final Builder domain(@NotNull String domain) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Builder $this$domain_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$domain_u24lambda_u247.apiBaseUrl = $this$domain_u24lambda_u247.formatApiBaseUrl(domain);
            return builder;
        }

        @NotNull
        public final Builder apiBaseUrl(@NotNull String apiBaseUrl2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)apiBaseUrl2, (String)"apiBaseUrl");
            Builder $this$apiBaseUrl_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$apiBaseUrl_u24lambda_u248.apiBaseUrl = apiBaseUrl2;
            return builder;
        }

        @NotNull
        public final Builder merchantCode(@NotNull String merchantCode) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)merchantCode, (String)"merchantCode");
            Builder $this$merchantCode_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$merchantCode_u24lambda_u249.merchantCode = merchantCode;
            return builder;
        }

        @NotNull
        public final Builder brand(@NotNull String brand) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
            Builder $this$brand_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$brand_u24lambda_u2410.brand = brand;
            return builder;
        }

        @NotNull
        public final Builder secret(@NotNull String secret) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Builder $this$secret_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$secret_u24lambda_u2411.secret = secret;
            return builder;
        }

        @NotNull
        public final Builder defaultTokenValidity(@NotNull Duration tokenValidity) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tokenValidity, (String)"tokenValidity");
            Builder $this$defaultTokenValidity_u24lambda_u2412 = builder = this;
            boolean bl = false;
            $this$defaultTokenValidity_u24lambda_u2412.defaultTokenValidity = tokenValidity;
            return builder;
        }

        @NotNull
        public final Builder defaultCallTimeout(@NotNull Duration callTimeout) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)callTimeout, (String)"callTimeout");
            Builder $this$defaultCallTimeout_u24lambda_u2413 = builder = this;
            boolean bl = false;
            $this$defaultCallTimeout_u24lambda_u2413.defaultCallTimeout = callTimeout;
            return builder;
        }

        @NotNull
        public final PaymentContext build() {
            String string = this.apiBaseUrl;
            if (string == null) {
                boolean $i$a$-requireNotNull-PaymentContext$Builder$build$42 = false;
                String $i$a$-requireNotNull-PaymentContext$Builder$build$42 = "One of 'domain' or 'apiBaseUrl' properties is mandatory.";
                throw new IllegalArgumentException($i$a$-requireNotNull-PaymentContext$Builder$build$42.toString());
            }
            String string2 = this.merchantCode;
            if (string2 == null) {
                int n = 2;
                String string3 = string;
                boolean $i$a$-requireNotNull-PaymentContext$Builder$build$52 = false;
                String string4 = "Property 'merchantCode' is mandatory.";
                String string5 = string3;
                int n2 = n;
                String $i$a$-requireNotNull-PaymentContext$Builder$build$52 = string4;
                throw new IllegalArgumentException($i$a$-requireNotNull-PaymentContext$Builder$build$52.toString());
            }
            String string6 = this.brand;
            String string7 = this.secret;
            if (string7 == null) {
                String string8 = string6;
                String string9 = string2;
                int n = 2;
                String string10 = string;
                boolean bl = false;
                String string11 = "Property 'secret' is mandatory.";
                String string12 = string10;
                int n3 = n;
                String string13 = string9;
                String string14 = string8;
                String string15 = string11;
                throw new IllegalArgumentException(string15.toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            Duration duration = this.defaultCallTimeout;
            Duration duration2 = this.defaultTokenValidity;
            String string16 = string7;
            String string17 = string6;
            String string18 = string2;
            int n = 2;
            String string19 = string;
            return new PaymentContext(string19, n, string18, string17, string16, duration2, duration, defaultConstructorMarker);
        }

        private static final String apiBaseUrl$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        private static final String apiBaseUrl$lambda$1(Builder this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return Optional.ofNullable(System.getenv(PaymentContext.ENV_TECH_CARPENTUM_SDK_PAYMENT_DOMAIN)).map(arg_0 -> Builder.apiBaseUrl$lambda$1$lambda$0((Function1)new Function1<String, String>((Object)this$0){

                public final String invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Builder.access$formatApiBaseUrl((Builder)this.receiver, p0);
                }
            }, arg_0)).orElse(null);
        }

        private static final Long defaultCallTimeout$lambda$2(String it) {
            long l;
            try {
                Intrinsics.checkNotNull((Object)it);
                l = Long.parseLong(it);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Environment variable TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT wrong number format: " + it);
            }
            return l;
        }

        private static final Long defaultCallTimeout$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Long)$tmp0.invoke(p0);
        }

        private static final Duration defaultCallTimeout$lambda$4(Long it) {
            Intrinsics.checkNotNull((Object)it);
            return Duration.ofSeconds(it);
        }

        private static final Duration defaultCallTimeout$lambda$5(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Duration)$tmp0.invoke(p0);
        }

        private static final Duration defaultCallTimeout$lambda$6() {
            return defaultCallTimeout;
        }

        public static final /* synthetic */ String access$formatApiBaseUrl(Builder $this, String domain) {
            return $this.formatApiBaseUrl(domain);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltech/carpentum/sdk/payment/PaymentContext$Factory;", "", "<init>", "()V", "ENV_TECH_CARPENTUM_SDK_PAYMENT_DOMAIN", "", "ENV_TECH_CARPENTUM_SDK_PAYMENT_API_BASE_URL", "ENV_TECH_CARPENTUM_SDK_PAYMENT_MERCHANT_CODE", "ENV_TECH_CARPENTUM_SDK_PAYMENT_SECRET", "ENV_TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT", "apiVersion", "", "apiBaseUrlPrefix", "defaultTokenValidity", "Ljava/time/Duration;", "defaultCallTimeout", "builder", "Ltech/carpentum/sdk/payment/PaymentContext$Builder;", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

