/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.TopUpRequestedMoneyRequiredImpl;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.TopUpRequested;

@JsonClass(generateAdapter=false)
public interface TopUpRequestedMoneyRequired
extends TopUpRequested {
    public static final TopUpRequested.TopUpRequestedType TOP_UP_REQUESTED_TYPE = TopUpRequested.TopUpRequestedType.MONEY_REQUIRED;

    @NotNull
    public Money getMoneyRequired();

    @NotNull
    public Optional<CurrencyCode> getCurrencyProvided();

    @NotNull
    public static Builder builder(TopUpRequestedMoneyRequired copyOf) {
        Builder builder = TopUpRequestedMoneyRequired.builder();
        builder.moneyRequired(copyOf.getMoneyRequired());
        builder.currencyProvided(copyOf.getCurrencyProvided().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new TopUpRequestedMoneyRequiredImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder moneyRequired(Money var1);

        @NotNull
        public Builder currencyProvided(CurrencyCode var1);

        @NotNull
        public TopUpRequestedMoneyRequired build();
    }
}

