/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseCapitecPay;
import tech.carpentum.sdk.payment.model.CapitecPayMethodResponse;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public class CapitecPayMethodResponseImpl
implements CapitecPayMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final Money money;
    private final Optional<MoneyVat> vat;
    private final String merchantName;
    private final Optional<AccountCustomerResponseCapitecPay> accountCustomer;
    private final Optional<String> phoneNumber;
    private final Optional<String> said;
    private final String reference;
    private final String returnUrl;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public Money getMoney() {
        return this.money;
    }

    @Override
    public Optional<MoneyVat> getVat() {
        return this.vat;
    }

    @Override
    public String getMerchantName() {
        return this.merchantName;
    }

    @Override
    public Optional<AccountCustomerResponseCapitecPay> getAccountCustomer() {
        return this.accountCustomer;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Optional<String> getSaid() {
        return this.said;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private CapitecPayMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.vat = Optional.ofNullable(builder.vat);
        this.merchantName = Objects.requireNonNull(builder.merchantName, "Property 'merchantName' is required.");
        this.accountCustomer = Optional.ofNullable(builder.accountCustomer);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.said = Optional.ofNullable(builder.said);
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.money, this.vat, this.merchantName, this.accountCustomer, this.phoneNumber, this.said, this.reference, this.returnUrl, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", money=" + this.money + ", vat=" + this.vat + ", merchantName=" + this.merchantName + ", accountCustomer=" + this.accountCustomer + ", phoneNumber=" + this.phoneNumber + ", said=" + this.said + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapitecPayMethodResponseImpl)) {
            return false;
        }
        CapitecPayMethodResponseImpl that = (CapitecPayMethodResponseImpl)obj;
        if (!this.idPayin.equals(that.idPayin)) {
            return false;
        }
        if (!this.idPayment.equals(that.idPayment)) {
            return false;
        }
        if (!this.money.equals(that.money)) {
            return false;
        }
        if (!this.vat.equals(that.vat)) {
            return false;
        }
        if (!this.merchantName.equals(that.merchantName)) {
            return false;
        }
        if (!this.accountCustomer.equals(that.accountCustomer)) {
            return false;
        }
        if (!this.phoneNumber.equals(that.phoneNumber)) {
            return false;
        }
        if (!this.said.equals(that.said)) {
            return false;
        }
        if (!this.reference.equals(that.reference)) {
            return false;
        }
        if (!this.returnUrl.equals(that.returnUrl)) {
            return false;
        }
        if (!this.acceptedAt.equals(that.acceptedAt)) {
            return false;
        }
        return this.expireAt.equals(that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements CapitecPayMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private Money money = null;
        private MoneyVat vat = null;
        private String merchantName = null;
        private AccountCustomerResponseCapitecPay accountCustomer = null;
        private String phoneNumber = null;
        private String said = null;
        private String reference = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("CapitecPayMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl vat(MoneyVat vat) {
            this.vat = vat;
            return this;
        }

        @Override
        public BuilderImpl merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @Override
        public BuilderImpl accountCustomer(AccountCustomerResponseCapitecPay accountCustomer) {
            this.accountCustomer = accountCustomer;
            return this;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public BuilderImpl said(String said) {
            this.said = said;
            return this;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public CapitecPayMethodResponseImpl build() {
            return new CapitecPayMethodResponseImpl(this);
        }
    }
}

