/*
 * Decompiled with CFR 0.152.
 */
package tech.beepbeep.beep_sdk_android;

import android.content.Context;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.beepbeep.beep_commons.ClientResponse;
import tech.beepbeep.beep_commons.CreditAction;
import tech.beepbeep.beep_commons.MachineState;
import tech.beepbeep.beep_commons.OrderItemStatus;
import tech.beepbeep.beep_commons.PaymentType;
import tech.beepbeep.beep_commons.payment.PaymentResultListener;
import tech.beepbeep.beep_commons.payment.bean.BeepOrder;
import tech.beepbeep.beep_commons.serial.bean.SerialPort;
import tech.beepbeep.beep_commons.util.BeepConnector;
import tech.beepbeep.beep_commons.util.Constants;
import tech.beepbeep.beep_commons.util.MessageBody;
import tech.beepbeep.beep_commons.util.MessageProcessor;
import tech.beepbeep.beep_commons.util.Utils;
import tech.beepbeep.beep_loader.BeepLoaderManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0004JZ\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0019J\u000e\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\nJ \u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,JG\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\n2*\u00101\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0302\"\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n03\u00a2\u0006\u0002\u00104J\u0016\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u0002072\u0006\u0010+\u001a\u00020,JC\u00108\u001a\u00020\u000426\u00109\u001a\u001c\u0012\u0018\b\u0001\u0012\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020;0:02\"\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020;0:\u00a2\u0006\u0002\u0010<Jc\u0010=\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&2N\u00109\u001a(\u0012$\b\u0001\u0012 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(03\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020;0:02\" \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(03\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020;0:\u00a2\u0006\u0002\u0010>\u00a8\u0006@"}, d2={"Ltech/beepbeep/beep_sdk_android/BeepManager;", "", "()V", "addPaymentListener", "", "paymentResultListener", "Ltech/beepbeep/beep_commons/payment/PaymentResultListener;", "cancelTransaction", "register", "uuid", "", "distributor", "token", "isDebug", "", "serialPortLists", "", "Ltech/beepbeep/beep_commons/serial/bean/SerialPort;", "beepConnector", "Ltech/beepbeep/beep_commons/util/BeepConnector;", "threadPool", "Ljava/util/concurrent/ExecutorService;", "context", "Landroid/content/Context;", "clientMessageProcessor", "Ltech/beepbeep/beep_commons/util/MessageProcessor;", "requestItems", "order", "Ltech/beepbeep/beep_commons/payment/bean/BeepOrder;", "requestTransaction", "setClientMessageProcessor", "messageProcessor", "setLogPath", "path", "updateCreditStatus", "action", "Ltech/beepbeep/beep_commons/CreditAction;", "type", "Ltech/beepbeep/beep_commons/PaymentType;", "amount", "", "updateMachineInput", "input", "paymentFlowId", "", "updateMachineState", "machineState", "Ltech/beepbeep/beep_commons/MachineState;", "description", "stateCode", "", "Lkotlin/Pair;", "(Ltech/beepbeep/beep_commons/MachineState;Ljava/lang/String;[Lkotlin/Pair;)V", "updateOptionalResponse", "response", "Ltech/beepbeep/beep_commons/ClientResponse;", "updateTransactionResult", "item", "Lkotlin/Triple;", "Ltech/beepbeep/beep_commons/OrderItemStatus;", "([Lkotlin/Triple;)V", "upload3rdPartyTransactionHistory", "(Ltech/beepbeep/beep_commons/PaymentType;[Lkotlin/Triple;)V", "Companion", "beep-sdk-android-1.1.12-dev_release"})
public final class BeepManager {
    @NotNull
    private static final String TAG;
    private static volatile BeepManager instance;
    public static final Companion Companion;

    public final void setLogPath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Utils.Companion.storeLog(path);
    }

    public final void register(@NotNull String uuid, @NotNull String distributor, @NotNull String token, boolean isDebug, @NotNull List<SerialPort> serialPortLists, @NotNull BeepConnector beepConnector, @Nullable ExecutorService threadPool, @Nullable Context context, @Nullable MessageProcessor clientMessageProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        Intrinsics.checkParameterIsNotNull((Object)distributor, (String)"distributor");
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull(serialPortLists, (String)"serialPortLists");
        Intrinsics.checkParameterIsNotNull((Object)beepConnector, (String)"beepConnector");
        Utils.Companion.printLog(TAG + ": Register Called With uuid: " + uuid + ", Distributor: " + distributor + ", Token: " + token + ", isDebug: " + isDebug);
        BeepLoaderManager beepLoaderManager = BeepLoaderManager.Companion.getInstance();
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        beepLoaderManager.loadAllService(context2, beepConnector, token, distributor, uuid, isDebug, serialPortLists, threadPool, clientMessageProcessor);
    }

    public final void addPaymentListener(@NotNull PaymentResultListener paymentResultListener) {
        Intrinsics.checkParameterIsNotNull((Object)paymentResultListener, (String)"paymentResultListener");
        Utils.Companion.printLog(TAG + ": Payment Listener Added");
        BeepLoaderManager.Companion.getInstance().addPaymentListener(paymentResultListener);
    }

    public final void setClientMessageProcessor(@NotNull MessageProcessor messageProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)messageProcessor, (String)"messageProcessor");
        Utils.Companion.printLog(TAG + ": Client Message Processor Set");
        BeepLoaderManager.Companion.getInstance().setClientMessageProcessor(messageProcessor);
    }

    public final void requestItems(@NotNull BeepOrder order) {
        Intrinsics.checkParameterIsNotNull((Object)order, (String)"order");
        Utils.Companion.printLog(TAG + ": Request Items with paymentTypeCode " + order.getPaymentTypeCode() + ", " + "paymentMethodCode " + order.getPaymentMethodCode() + ", paymentFlowId " + order.getPaymentFlowId() + ", credit " + order.getCredit() + ", with Items: ");
        Iterable $this$forEach$iv = order.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Utils.Companion.printLog("Price: " + ((Number)it.getFirst()).doubleValue() + ", Item: " + (String)it.getSecond());
        }
        BeepLoaderManager.Companion.getInstance().sendMessage("payment_service", new MessageBody(Integer.valueOf(Constants.Payment.REQUEST_ITEM.getValue()), null, null, null, (Object)order, null, null, null, null, 494, null));
    }

    public final void requestTransaction(@NotNull BeepOrder order) {
        Intrinsics.checkParameterIsNotNull((Object)order, (String)"order");
        Utils.Companion.printLog(TAG + ": Request Transaction with paymentTypeCode " + order.getPaymentTypeCode() + ", " + "paymentMethodCode " + order.getPaymentMethodCode() + ", paymentFlowId " + order.getPaymentFlowId() + ", credit " + order.getCredit() + ", with Items: ");
        Iterable $this$forEach$iv = order.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Utils.Companion.printLog("Price: " + ((Number)it.getFirst()).doubleValue() + ", Item: " + (String)it.getSecond());
        }
        BeepLoaderManager.Companion.getInstance().sendMessage("payment_service", new MessageBody(Integer.valueOf(Constants.Payment.REQUEST_TRANSACTION.getValue()), null, null, null, (Object)order, null, null, null, null, 494, null));
    }

    public final void updateOptionalResponse(@NotNull ClientResponse response, int paymentFlowId) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Utils.Companion.printLog(TAG + ": Update Optional Response with Response: " + response.name() + " and paymentFlowId: " + paymentFlowId);
        BeepLoaderManager.Companion.getInstance().sendMessage("payment_service", new MessageBody(Integer.valueOf(Constants.Payment.UPDATE_OPTIONAL_RESPONSE.getValue()), Integer.valueOf(paymentFlowId), null, null, (Object)response, null, null, null, null, 492, null));
    }

    public final void updateMachineInput(@NotNull String input, int paymentFlowId) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Utils.Companion.printLog(TAG + ": Update Machine Input with input: " + input + " and paymentFlowId: " + paymentFlowId);
        BeepLoaderManager.Companion.getInstance().sendMessage("payment_service", new MessageBody(Integer.valueOf(Constants.Payment.UPDATE_MACHINE_INPUT.getValue()), Integer.valueOf(paymentFlowId), null, null, (Object)input, null, null, null, null, 492, null));
    }

    public final void cancelTransaction() {
        Utils.Companion.printLog(TAG + ": Cancel Transaction");
        BeepLoaderManager.Companion.getInstance().sendMessage("payment_service", new MessageBody(Integer.valueOf(Constants.Payment.CANCEL_TRANSACTION.getValue()), null, null, null, null, null, null, null, null, 510, null));
    }

    public final void updateTransactionResult(Triple<Double, String, ? extends OrderItemStatus> ... item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        Utils.Companion.printLog(TAG + ": Update Transaction Result with Items");
        Iterator $this$forEach$iv = ArrayIteratorKt.iterator((Object[])item);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Triple it = (Triple)element$iv;
            boolean bl2 = false;
            Utils.Companion.printLog("Price: " + ((Number)it.getFirst()).doubleValue() + ", Item: " + (String)it.getSecond() + ", Order Status: " + ((OrderItemStatus)it.getThird()).name());
        }
        BeepLoaderManager.Companion.getInstance().sendMessage("payment_service", new MessageBody(Integer.valueOf(Constants.Payment.UPDATE_TRANSACTION_RESULT.getValue()), null, null, null, (Object)CollectionsKt.listOf((Object[])Arrays.copyOf(item, item.length)), null, null, null, null, 494, null));
    }

    public final void upload3rdPartyTransactionHistory(@NotNull PaymentType type, Triple<Pair<Double, Double>, String, ? extends OrderItemStatus> ... item) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        Utils.Companion.printLog(TAG + ": Update 3rd Party Txn History For Payment Type: " + type.name() + " with Items");
        Iterator $this$forEach$iv = ArrayIteratorKt.iterator((Object[])item);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Triple it = (Triple)element$iv;
            boolean bl2 = false;
            Utils.Companion.printLog("Price: " + ((Number)((Pair)it.getFirst()).getFirst()).doubleValue() + ", Credits: " + ((Number)((Pair)it.getFirst()).getSecond()).doubleValue() + ", Item: " + (String)it.getSecond() + ", Order Status: " + ((OrderItemStatus)it.getThird()).name());
        }
        BeepLoaderManager.Companion.getInstance().sendMessage("core_service", new MessageBody(Integer.valueOf(Constants.Payment.THIRD_PARTY_TRANSACTION_RESULT.getValue()), Integer.valueOf(type.getValue()), null, null, (Object)CollectionsKt.listOf((Object[])Arrays.copyOf(item, item.length)), null, null, null, null, 492, null));
    }

    public final void updateMachineState(@NotNull MachineState machineState, @NotNull String description, Pair<String, String> ... stateCode) {
        Intrinsics.checkParameterIsNotNull((Object)machineState, (String)"machineState");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull(stateCode, (String)"stateCode");
        Utils.Companion.printLog(TAG + ": Update Machine State to State: " + machineState.name() + " and Description: " + description + " with subStateCodes:");
        Iterator $this$forEach$iv = ArrayIteratorKt.iterator((Object[])stateCode);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Pair it = (Pair)element$iv;
            boolean bl2 = false;
            Utils.Companion.printLog("SubState: " + (String)it.getFirst() + " With Reason: " + (String)it.getSecond());
        }
        BeepLoaderManager.Companion.getInstance().updateMachineState(machineState, description, Arrays.copyOf(stateCode, stateCode.length));
    }

    public final void updateCreditStatus(@NotNull CreditAction action, @Nullable PaymentType type, double amount) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Utils.Companion.printLog(TAG + ": Update Credit Status with Action: " + action + " and amount " + amount + " and type " + type);
        if (type != null && type != PaymentType.CASH && type != PaymentType.TERMINAL) {
            Throwable throwable = new Exception("Attempting to updateCreditStatus with invalid PaymentType " + type);
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            String string = thread.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Thread.currentThread().name");
            Utils.Companion.recordCrash(throwable, TAG, string);
        }
        PaymentType paymentType = type;
        BeepLoaderManager.Companion.getInstance().sendMessage("core_service", new MessageBody(Integer.valueOf(Constants.Payment.UPDATE_CREDIT_STATUS.getValue()), Integer.valueOf(action.getAction()), null, null, (Object)(paymentType != null ? paymentType.getType() : null), type == PaymentType.CASH ? "EXTERNAL_CASH" : (type == PaymentType.TERMINAL ? "EXTERNAL_CASHLESS" : (type == null ? null : "UNKNOWN METHOD")), (Object)amount, null, null, 396, null));
    }

    static {
        Companion = new Companion(null);
        String string = BeepManager.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BeepManager::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltech/beepbeep/beep_sdk_android/BeepManager$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "instance", "Ltech/beepbeep/beep_sdk_android/BeepManager;", "getInstance", "beep-sdk-android-1.1.12-dev_release"})
    public static final class Companion {
        @NotNull
        public final String getTAG() {
            return TAG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final BeepManager getInstance() {
            BeepManager beepManager = instance;
            if (beepManager == null) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (this) {
                    boolean bl3 = false;
                    BeepManager beepManager2 = instance;
                    if (beepManager2 == null) {
                        BeepManager beepManager3 = new BeepManager();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        BeepManager it = beepManager3;
                        boolean bl6 = false;
                        instance = it;
                        beepManager2 = beepManager3;
                    }
                    BeepManager beepManager4 = beepManager2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl20 : MonitorExitStatement: MONITOREXIT : this
                    beepManager = beepManager4;
                }
            }
            return beepManager;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

