/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.codehaus.jackson.map.ObjectMapper;
import tech.allegro.schema.json2avro.converter.AvroConversionException;
import tech.allegro.schema.json2avro.converter.AvroTypeExceptions;

public class JsonGenericRecordReader {
    private static final Object INCOMPATIBLE = new Object();
    private final ObjectMapper mapper;

    public JsonGenericRecordReader() {
        this(new ObjectMapper());
    }

    public JsonGenericRecordReader(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public GenericData.Record read(byte[] data, Schema schema) {
        try {
            return this.read((Map)this.mapper.readValue(data, Map.class), schema);
        }
        catch (IOException ex) {
            throw new AvroConversionException("Failed to parse json to map format.", ex);
        }
    }

    public GenericData.Record read(Map<String, Object> json, Schema schema) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        try {
            return this.readRecord(json, schema, path);
        }
        catch (AvroRuntimeException ex) {
            throw new AvroConversionException("Failed to convert JSON to Avro", ex);
        }
    }

    private GenericData.Record readRecord(Map<String, Object> json, Schema schema, Deque<String> path) {
        GenericRecordBuilder record = new GenericRecordBuilder(schema);
        json.entrySet().forEach(entry -> Optional.ofNullable(schema.getField((String)entry.getKey())).ifPresent(field -> record.set(field, this.read((Schema.Field)field, field.schema(), entry.getValue(), path, false))));
        return record.build();
    }

    private Object read(Schema.Field field, Schema schema, Object value, Deque<String> path, boolean silently) {
        Object result;
        boolean pushed;
        boolean bl = pushed = !field.name().equals(path.peek());
        if (pushed) {
            path.push(field.name());
        }
        switch (schema.getType()) {
            case RECORD: {
                result = this.onValidType(value, Map.class, path, silently, map -> this.readRecord((Map<String, Object>)map, schema, path));
                break;
            }
            case ARRAY: {
                result = this.onValidType(value, List.class, path, silently, list -> this.readArray(field, schema, (List<Object>)list, path));
                break;
            }
            case MAP: {
                result = this.onValidType(value, Map.class, path, silently, map -> this.readMap(field, schema, (Map<String, Object>)map, path));
                break;
            }
            case UNION: {
                result = this.readUnion(field, schema, value, path);
                break;
            }
            case INT: {
                result = this.onValidNumber(value, path, silently, Number::intValue);
                break;
            }
            case LONG: {
                result = this.onValidNumber(value, path, silently, Number::longValue);
                break;
            }
            case FLOAT: {
                result = this.onValidNumber(value, path, silently, Number::floatValue);
                break;
            }
            case DOUBLE: {
                result = this.onValidNumber(value, path, silently, Number::doubleValue);
                break;
            }
            case BOOLEAN: {
                result = this.onValidType(value, Boolean.class, path, silently, bool -> bool);
                break;
            }
            case ENUM: {
                result = this.onValidType(value, String.class, path, silently, string -> this.ensureEnum(schema, string, path));
                break;
            }
            case STRING: {
                result = this.onValidType(value, String.class, path, silently, string -> string);
                break;
            }
            case NULL: {
                result = value == null ? value : INCOMPATIBLE;
                break;
            }
            default: {
                throw new AvroTypeException("Unsupported type: " + field.schema().getType());
            }
        }
        if (pushed) {
            path.pop();
        }
        return result;
    }

    private List<Object> readArray(Schema.Field field, Schema schema, List<Object> items, Deque<String> path) {
        return items.stream().map(item -> this.read(field, schema.getElementType(), item, path, false)).collect(Collectors.toList());
    }

    private Map<String, Object> readMap(Schema.Field field, Schema schema, Map<String, Object> map, Deque<String> path) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.read(field, schema.getValueType(), entry.getValue(), path, false)));
    }

    private Object readUnion(Schema.Field field, Schema schema, Object value, Deque<String> path) {
        List types = schema.getTypes();
        for (Schema type : types) {
            try {
                Object nestedValue = this.read(field, type, value, path, true);
                if (nestedValue == INCOMPATIBLE) continue;
                return nestedValue;
            }
            catch (AvroRuntimeException e) {
            }
        }
        throw AvroTypeExceptions.unionException(field.name(), types.stream().map(Schema::getType).map(Object::toString).collect(Collectors.joining(", ")), path);
    }

    private Object ensureEnum(Schema schema, Object value, Deque<String> path) {
        List symbols = schema.getEnumSymbols();
        if (symbols.contains(value)) {
            return value;
        }
        throw AvroTypeExceptions.enumException(path, symbols.stream().map(String::valueOf).collect(Collectors.joining(", ")));
    }

    public <T> Object onValidType(Object value, Class<T> type, Deque<String> path, boolean silently, Function<T, Object> function) throws AvroTypeException {
        if (type.isInstance(value)) {
            return function.apply(value);
        }
        if (silently) {
            return INCOMPATIBLE;
        }
        throw AvroTypeExceptions.typeException(path, type.getTypeName());
    }

    public Object onValidNumber(Object value, Deque<String> path, boolean silently, Function<Number, Object> function) {
        return this.onValidType(value, Number.class, path, silently, function);
    }
}

