/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.codehaus.jackson.map.ObjectMapper;
import tech.allegro.schema.json2avro.converter.AvroConversionException;

public class JsonGenericRecordReader {
    private ObjectMapper mapper;

    public JsonGenericRecordReader() {
        this.mapper = new ObjectMapper();
    }

    public JsonGenericRecordReader(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public GenericData.Record read(byte[] data, Schema schema) {
        try {
            return this.read((Map)this.mapper.readValue(data, Map.class), schema);
        }
        catch (IOException ex) {
            throw new AvroConversionException("Failed to parse json to map format.", ex);
        }
    }

    public GenericData.Record read(Map<String, Object> json, Schema schema) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        try {
            return this.readRecord(json, schema, path);
        }
        catch (AvroRuntimeException ex) {
            throw new AvroConversionException("Failed to convert JSON to Avro", ex);
        }
    }

    private GenericData.Record readRecord(Map<String, Object> json, Schema schema, Deque<String> path) {
        GenericRecordBuilder record = new GenericRecordBuilder(schema);
        json.entrySet().forEach(entry -> Optional.ofNullable(schema.getField((String)entry.getKey())).ifPresent(field -> record.set(field, this.read((Schema.Field)field, field.schema(), entry.getValue(), path))));
        return record.build();
    }

    private Object read(Schema.Field field, Schema schema, Object value, Deque<String> path) {
        Object result;
        boolean pushed;
        boolean bl = pushed = !field.name().equals(path.peek());
        if (pushed) {
            path.push(field.name());
        }
        switch (schema.getType()) {
            case RECORD: {
                result = this.readRecord(this.ensureType(value, Map.class, path), schema, path);
                break;
            }
            case ARRAY: {
                result = this.readArray(field, schema, this.ensureType(value, List.class, path), path);
                break;
            }
            case MAP: {
                result = this.readMap(field, schema, this.ensureType(value, Map.class, path), path);
                break;
            }
            case UNION: {
                result = this.readUnion(field, schema, value, path);
                break;
            }
            case INT: {
                result = this.ensureType(value, Number.class, path).intValue();
                break;
            }
            case LONG: {
                result = this.ensureType(value, Number.class, path).longValue();
                break;
            }
            case FLOAT: {
                result = Float.valueOf(this.ensureType(value, Number.class, path).floatValue());
                break;
            }
            case DOUBLE: {
                result = this.ensureType(value, Number.class, path).doubleValue();
                break;
            }
            case BOOLEAN: {
                result = this.ensureType(value, Boolean.class, path);
                break;
            }
            case ENUM: {
                result = this.ensureType(value, String.class, path);
                break;
            }
            case STRING: {
                result = this.ensureType(value, String.class, path);
                break;
            }
            case NULL: {
                result = this.ensureNull(value, path);
                break;
            }
            default: {
                throw new AvroTypeException("Unsupported type: " + field.schema().getType());
            }
        }
        if (pushed) {
            path.pop();
        }
        return result;
    }

    private List<Object> readArray(Schema.Field field, Schema schema, List<Object> items, Deque<String> path) {
        return items.stream().map(item -> this.read(field, schema.getElementType(), item, path)).collect(Collectors.toList());
    }

    private Map<String, Object> readMap(Schema.Field field, Schema schema, Map<String, Object> map, Deque<String> path) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.read(field, schema.getValueType(), entry.getValue(), path)));
    }

    private Object readUnion(Schema.Field field, Schema schema, Object value, Deque<String> path) {
        List types = schema.getTypes();
        for (Schema type : types) {
            try {
                return this.read(field, type, value, path);
            }
            catch (AvroRuntimeException ex) {
            }
        }
        throw new AvroTypeException(String.format("Could not evaluate union, field %s is expected to be one of these: %s. If this is a complex type, check if offending field: %s adheres to schema.", field.name(), types.stream().map(Schema::getType).map(Object::toString).collect(Collectors.joining(",")), this.path(path)));
    }

    private <T> T ensureType(Object value, Class<T> type, Deque<String> path) {
        if (type.isInstance(value)) {
            return (T)value;
        }
        throw new AvroTypeException(String.format("Field %s is expected to be of %s type.", this.path(path), type.getName()));
    }

    private Object ensureNull(Object o, Deque<String> path) {
        if (o != null) {
            throw new AvroTypeException(String.format("Field %s was expected to be null.", this.path(path)));
        }
        return null;
    }

    private String path(Deque<String> path) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(path.descendingIterator(), 16), false).map(Object::toString).collect(Collectors.joining("."));
    }
}

