/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.util.Deque;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecordBuilder;
import tech.allegro.schema.json2avro.converter.JsonToAvroReader;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.UnknownFieldListener;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverterWithStrictJavaTypeCheck;

public class RecordConverter
extends AvroTypeConverterWithStrictJavaTypeCheck<Map> {
    private final JsonToAvroReader jsonToAvroReader;
    private final UnknownFieldListener unknownFieldListener;

    public RecordConverter(JsonToAvroReader jsonToAvroReader, UnknownFieldListener unknownFieldListener) {
        super(Map.class);
        this.jsonToAvroReader = jsonToAvroReader;
        this.unknownFieldListener = unknownFieldListener;
    }

    @Override
    public Object convertValue(Schema.Field field, Schema schema, Map jsonValue, Deque<String> path, boolean silently) {
        GenericRecordBuilder record = new GenericRecordBuilder(schema);
        jsonValue.forEach((key, value) -> {
            Schema.Field subField = schema.getField(key);
            if (subField != null) {
                record.set(subField, this.jsonToAvroReader.read(subField, subField.schema(), value, path, false));
            } else if (this.unknownFieldListener != null) {
                this.unknownFieldListener.onUnknownField((String)key, value, PathsPrinter.print(path, key));
            }
        });
        return record.build();
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> path) {
        return schema.getType().equals((Object)Schema.Type.RECORD);
    }
}

