/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.time.format.DateTimeParseException;
import java.util.Deque;
import org.apache.avro.AvroTypeException;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;

public abstract class AbstractDateTimeConverter
implements AvroTypeConverter {
    @Override
    public Object convert(Schema.Field field, Schema schema, Object jsonValue, Deque<String> path, boolean silently) {
        if (jsonValue instanceof String) {
            String dateTimeString = (String)jsonValue;
            try {
                return this.parseDateTime(dateTimeString);
            }
            catch (DateTimeParseException exception) {
                if (silently) {
                    return new AvroTypeConverter.Incompatible(this.getValidJsonFormat());
                }
                throw new AvroTypeException("Field " + PathsPrinter.print(path) + " should be a valid " + this.getValidStringFormat() + ".");
            }
        }
        if (jsonValue instanceof Number) {
            return this.toTargetNumberFormat((Number)jsonValue);
        }
        if (silently) {
            return new AvroTypeConverter.Incompatible(this.getValidJsonFormat());
        }
        throw new AvroTypeException("Field " + PathsPrinter.print(path) + " is expected to be type: java.lang.String or java.lang.Number.");
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> path) {
        return this.getUnderlyingSchemaType().equals((Object)schema.getType()) && AvroTypeConverter.isLogicalType(schema, this.getLogicalType().getName());
    }

    protected abstract Object parseDateTime(String var1);

    protected abstract Object toTargetNumberFormat(Number var1);

    protected abstract Schema.Type getUnderlyingSchemaType();

    protected abstract LogicalType getLogicalType();

    private String getValidJsonFormat() {
        return this.getValidStringFormat() + " string, " + this.getValidNumberFormat() + " number";
    }

    protected abstract String getValidStringFormat();

    protected abstract String getValidNumberFormat();
}

