/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Deque;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;

public class LongTimestampMillisConverter
implements AvroTypeConverter {
    public static final AvroTypeConverter INSTANCE = new LongTimestampMillisConverter(DateTimeFormatter.ISO_DATE_TIME);
    public static final String VALID_JSON_FORMAT = "date time string, timestamp number";
    private final DateTimeFormatter dateTimeFormatter;

    public LongTimestampMillisConverter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public Object convert(Schema.Field field, Schema schema, Object jsonValue, Deque<String> path, boolean silently) {
        if (jsonValue instanceof String) {
            String dateString = (String)jsonValue;
            try {
                long dateTimestamp = this.dateTimeFormatter.parse(dateString).getLong(ChronoField.INSTANT_SECONDS);
                return dateTimestamp * 1000L;
            }
            catch (DateTimeParseException exception) {
                if (silently) {
                    return new AvroTypeConverter.Incompatible(VALID_JSON_FORMAT);
                }
                throw new AvroTypeException("Field " + PathsPrinter.print(path) + " should be a valid date time.");
            }
        }
        if (jsonValue instanceof Number) {
            return ((Number)jsonValue).longValue();
        }
        if (silently) {
            return new AvroTypeConverter.Incompatible(VALID_JSON_FORMAT);
        }
        throw new AvroTypeException("Field " + PathsPrinter.print(path) + " is expected to be type: java.lang.String or java.lang.Number.");
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> deque) {
        return Schema.Type.LONG.equals((Object)schema.getType()) && AvroTypeConverter.isLogicalType(schema, "timestamp-millis");
    }
}

