/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Deque;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;

public class BytesDecimalConverter
implements AvroTypeConverter {
    public static final AvroTypeConverter INSTANCE = new BytesDecimalConverter();

    private BytesDecimalConverter() {
    }

    @Override
    public Object convert(Schema.Field field, Schema schema, Object value, Deque<String> path, boolean silently) {
        int scale = (Integer)schema.getObjectProp("scale");
        try {
            BigDecimal bigDecimal = this.bigDecimalWithExpectedScale(value.toString(), scale);
            return ByteBuffer.wrap(bigDecimal.unscaledValue().toByteArray());
        }
        catch (NumberFormatException exception) {
            if (silently) {
                return new AvroTypeConverter.Incompatible("string number, decimal");
            }
            throw new AvroTypeException("Field " + PathsPrinter.print(path) + " is expected to be a valid number. current value is " + value + ".");
        }
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> deque) {
        return Schema.Type.BYTES.equals((Object)schema.getType()) && AvroTypeConverter.isLogicalType(schema, "decimal") && schema.getObjectProp("scale") != null;
    }

    private BigDecimal bigDecimalWithExpectedScale(String decimal, int scale) {
        BigDecimal bigDecimalInput = new BigDecimal(decimal);
        return bigDecimalInput.multiply(BigDecimal.TEN.pow(scale - bigDecimalInput.scale()));
    }
}

