/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import tech.allegro.schema.json2avro.converter.JsonToAvroReader;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;

public class UnionConverter
implements AvroTypeConverter {
    private final JsonToAvroReader jsonToAvroReader;

    public UnionConverter(JsonToAvroReader jsonToAvroReader) {
        this.jsonToAvroReader = jsonToAvroReader;
    }

    @Override
    public Object convert(Schema.Field field, Schema schema, Object jsonValue, Deque<String> path, boolean silently) {
        List types = schema.getTypes();
        for (Schema type : types) {
            try {
                Object nestedValue = this.jsonToAvroReader.read(field, type, jsonValue, path, true);
                if (nestedValue == INCOMPATIBLE) continue;
                return nestedValue;
            }
            catch (AvroRuntimeException e) {
            }
        }
        throw UnionConverter.unionException(field.name(), types.stream().map(Schema::getType).map(Object::toString).collect(Collectors.joining(", ")), path);
    }

    @Override
    public boolean canManage(Schema schema, Deque<String> path) {
        return schema.getType().equals((Object)Schema.Type.UNION);
    }

    private static AvroTypeException unionException(String fieldName, String expectedTypes, Deque<String> offendingPath) {
        return new AvroTypeException("Could not evaluate union, field " + fieldName + " is expected to be one of these: " + expectedTypes + ". If this is a complex type, check if offending field: " + PathsPrinter.print(offendingPath) + " adheres to schema.");
    }
}

