/*
 * Decompiled with CFR 0.152.
 */
package tech.allegro.schema.json2avro.converter.types;

import java.util.Deque;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import tech.allegro.schema.json2avro.converter.PathsPrinter;
import tech.allegro.schema.json2avro.converter.types.AvroTypeConverter;

public abstract class AvroTypeConverterWithStrictJavaTypeCheck<T>
implements AvroTypeConverter {
    private final Class<T> javaType;

    protected AvroTypeConverterWithStrictJavaTypeCheck(Class<T> javaType) {
        this.javaType = javaType;
    }

    @Override
    public Object convert(Schema.Field field, Schema schema, Object jsonValue, Deque<String> path, boolean silently) {
        if (this.javaType.isInstance(jsonValue)) {
            return this.convertValue(field, schema, jsonValue, path, silently);
        }
        if (silently) {
            return INCOMPATIBLE;
        }
        throw AvroTypeConverterWithStrictJavaTypeCheck.typeException(path, this.javaType.getTypeName());
    }

    public abstract Object convertValue(Schema.Field var1, Schema var2, T var3, Deque<String> var4, boolean var5);

    private static AvroTypeException typeException(Deque<String> fieldPath, String expectedType) {
        return new AvroTypeException("Field " + PathsPrinter.print(fieldPath) + " is expected to be type: " + expectedType);
    }
}

