/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.unit;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import tec.uom.se.AbstractSystemOfUnits;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.function.AddConverter;
import tec.uom.se.function.Nameable;
import tec.uom.se.function.PiMultiplierConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.quantity.QuantityDimension;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.BaseUnit;
import tec.uom.se.unit.MetricPrefix;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;

public class Units
extends AbstractSystemOfUnits
implements Nameable {
    private static final Units INSTANCE = new Units();
    public static final Unit<Dimensionless> ONE = Units.addUnit(new ProductUnit(), Dimensionless.class);
    public static final BaseUnit<ElectricCurrent> AMPERE = Units.addUnit(new BaseUnit("A", QuantityDimension.ELECTRIC_CURRENT), ElectricCurrent.class);
    public static final BaseUnit<LuminousIntensity> CANDELA = Units.addUnit(new BaseUnit("cd", QuantityDimension.LUMINOUS_INTENSITY), LuminousIntensity.class);
    public static final BaseUnit<Temperature> KELVIN = Units.addUnit(new BaseUnit("K", QuantityDimension.TEMPERATURE), Temperature.class);
    public static final BaseUnit<Mass> KILOGRAM = Units.addUnit(new BaseUnit("kg", QuantityDimension.MASS), Mass.class);
    public static final Unit<Length> METRE = Units.addUnit(new BaseUnit("m", QuantityDimension.LENGTH), Length.class);
    public static final Unit<AmountOfSubstance> MOLE = Units.addUnit(new BaseUnit("mol", QuantityDimension.AMOUNT_OF_SUBSTANCE), AmountOfSubstance.class);
    public static final Unit<Time> SECOND = Units.addUnit(new BaseUnit("s", QuantityDimension.TIME), Time.class);
    public static final Unit<Mass> GRAM = Units.addUnit(KILOGRAM.divide(1000.0));
    public static final Unit<Angle> RADIAN = Units.addUnit(new AlternateUnit(ONE, "rad"), Angle.class);
    public static final AlternateUnit<SolidAngle> STERADIAN = Units.addUnit(new AlternateUnit(ONE, "sr"), SolidAngle.class);
    public static final AlternateUnit<Frequency> HERTZ = Units.addUnit(new AlternateUnit(ONE.divide(SECOND), "Hz"), Frequency.class);
    public static final AlternateUnit<Force> NEWTON = Units.addUnit(new AlternateUnit(METRE.multiply(KILOGRAM).divide(SECOND.pow(2)), "N"), Force.class);
    public static final AlternateUnit<Pressure> PASCAL = Units.addUnit(new AlternateUnit(NEWTON.divide(METRE.pow(2)), "Pa"), Pressure.class);
    public static final AlternateUnit<Energy> JOULE = Units.addUnit(new AlternateUnit(NEWTON.multiply(METRE), "J"), Energy.class);
    public static final AlternateUnit<Power> WATT = Units.addUnit(new AlternateUnit(JOULE.divide(SECOND), "W"), Power.class);
    public static final AlternateUnit<ElectricCharge> COULOMB = Units.addUnit(new AlternateUnit(SECOND.multiply(AMPERE), "C"), ElectricCharge.class);
    public static final AlternateUnit<ElectricPotential> VOLT = Units.addUnit(new AlternateUnit(WATT.divide((AbstractUnit<?>)AMPERE), "V"), ElectricPotential.class);
    public static final AlternateUnit<ElectricCapacitance> FARAD = Units.addUnit(new AlternateUnit(COULOMB.divide((AbstractUnit<?>)VOLT), "F"), ElectricCapacitance.class);
    public static final AlternateUnit<ElectricResistance> OHM = Units.addUnit(new AlternateUnit(VOLT.divide((AbstractUnit<?>)AMPERE), "\u03a9"), ElectricResistance.class);
    public static final AlternateUnit<ElectricConductance> SIEMENS = Units.addUnit(new AlternateUnit(AMPERE.divide((AbstractUnit<?>)VOLT), "S"), ElectricConductance.class);
    public static final AlternateUnit<MagneticFlux> WEBER = Units.addUnit(new AlternateUnit(VOLT.multiply(SECOND), "Wb"), MagneticFlux.class);
    public static final AlternateUnit<MagneticFluxDensity> TESLA = Units.addUnit(new AlternateUnit(WEBER.divide(METRE.pow(2)), "T"), MagneticFluxDensity.class);
    public static final AlternateUnit<ElectricInductance> HENRY = Units.addUnit(new AlternateUnit(WEBER.divide((AbstractUnit<?>)AMPERE), "H"), ElectricInductance.class);
    public static final TransformedUnit<Temperature> CELSIUS = Units.addUnit(new TransformedUnit<Temperature>(KELVIN, new AddConverter(273.15)));
    public static final AlternateUnit<LuminousFlux> LUMEN = Units.addUnit(new AlternateUnit(CANDELA.multiply((AbstractUnit<?>)STERADIAN), "lm"), LuminousFlux.class);
    public static final AlternateUnit<Illuminance> LUX = Units.addUnit(new AlternateUnit(LUMEN.divide(METRE.pow(2)), "lx"), Illuminance.class);
    public static final AlternateUnit<Radioactivity> BECQUEREL = Units.addUnit(new AlternateUnit(ONE.divide(SECOND), "Bq"), Radioactivity.class);
    public static final AlternateUnit<RadiationDoseAbsorbed> GRAY = Units.addUnit(new AlternateUnit(JOULE.divide((AbstractUnit<?>)KILOGRAM), "Gy"), RadiationDoseAbsorbed.class);
    public static final AlternateUnit<RadiationDoseEffective> SIEVERT = Units.addUnit(new AlternateUnit(JOULE.divide((AbstractUnit<?>)KILOGRAM), "Sv"), RadiationDoseEffective.class);
    public static final AlternateUnit<CatalyticActivity> KATAL = Units.addUnit(new AlternateUnit(MOLE.divide(SECOND), "kat"), CatalyticActivity.class);
    public static final Unit<Speed> METRES_PER_SECOND = Units.addUnit(new ProductUnit(METRE.divide(SECOND)), Speed.class);
    public static final Unit<Acceleration> METRES_PER_SQUARE_SECOND = Units.addUnit(new ProductUnit(METRES_PER_SECOND.divide(SECOND)), Acceleration.class);
    public static final Unit<Area> SQUARE_METRE = Units.addUnit(new ProductUnit(METRE.multiply(METRE)), Area.class);
    public static final ProductUnit<Volume> CUBIC_METRE = Units.addUnit(new ProductUnit(SQUARE_METRE.multiply(METRE)), Volume.class);
    public static final Unit<Speed> KILOMETRES_PER_HOUR = Units.addUnit(METRES_PER_SECOND.multiply(0.277778)).asType(Speed.class);
    public static final TransformedUnit<Dimensionless> PERCENT = new TransformedUnit<Dimensionless>(ONE, new RationalConverter(1L, 100L));
    public static final Unit<Time> MINUTE = new TransformedUnit<Time>("min", SECOND, new RationalConverter(60L, 1L));
    public static final Unit<Time> HOUR = new TransformedUnit<Time>("h", SECOND, new RationalConverter(3600L, 1L));
    public static final Unit<Time> DAY = new TransformedUnit<Time>("d", SECOND, new RationalConverter(86400L, 1L));
    static final Unit<Time> WEEK = Units.addUnit(DAY.multiply(7.0));
    public static final Unit<Time> YEAR = Units.addUnit(DAY.multiply(365.2525));
    public static final Unit<Angle> DEGREE_ANGLE = Units.addUnit(new TransformedUnit<Angle>(RADIAN, new PiMultiplierConverter().concatenate(new RationalConverter(1L, 180L))));
    public static final Unit<Angle> MINUTE_ANGLE = Units.addUnit(new TransformedUnit<Angle>(RADIAN, new PiMultiplierConverter().concatenate(new RationalConverter(1L, 10800L))));
    public static final Unit<Angle> SECOND_ANGLE = Units.addUnit(new TransformedUnit<Angle>(RADIAN, new PiMultiplierConverter().concatenate(new RationalConverter(1L, 648000L))));
    public static final Unit<Volume> LITRE = Units.addUnit(new TransformedUnit<Volume>(CUBIC_METRE, new RationalConverter(1L, 1000L)));

    protected Units() {
    }

    @Override
    public String getName() {
        return Units.class.getSimpleName();
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        Units.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        Units.INSTANCE.units.add(unit);
        Units.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }

    static {
        SimpleUnitFormat.getInstance().label(KILOMETRES_PER_HOUR, "kph");
        SimpleUnitFormat.getInstance().label(MetricPrefix.KILO(METRE), "km");
        SimpleUnitFormat.getInstance().label(LITRE, "l");
    }
}

