/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.unit;

import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.uom.se.AbstractUnit;
import tec.uom.se.function.UnitConverterSupplier;

public final class TransformedUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q>
implements UnitConverterSupplier {
    private static final long serialVersionUID = 1L;
    private final AbstractUnit<Q> parentUnit;
    private final UnitConverter converter;
    private String symbol;

    public TransformedUnit(Unit<Q> parentUnit, UnitConverter unitConverter) {
        this(parentUnit.getSymbol(), parentUnit, unitConverter);
    }

    public TransformedUnit(String symbol, Unit<Q> parentUnit, UnitConverter unitConverter) {
        AbstractUnit abParent;
        if (parentUnit instanceof AbstractUnit) {
            abParent = (AbstractUnit)parentUnit;
            if (!abParent.isSystemUnit()) {
                throw new IllegalArgumentException("The parent unit: " + abParent + " is not a system unit");
            }
        } else {
            throw new IllegalArgumentException("The parent unit: " + parentUnit + " is not an abstract unit.");
        }
        this.parentUnit = abParent;
        this.converter = unitConverter;
    }

    @Override
    public Dimension getDimension() {
        return this.parentUnit.getDimension();
    }

    @Override
    public UnitConverter getSystemConverter() {
        return this.parentUnit.getSystemConverter().concatenate(this.converter);
    }

    @Override
    public UnitConverter getConverter() {
        return this.converter;
    }

    @Override
    public AbstractUnit<Q> toSystemUnit() {
        return this.parentUnit.getSystemUnit();
    }

    @Override
    public Map<? extends Unit<?>, Integer> getProductUnits() {
        return this.parentUnit.getProductUnits();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parentUnit, this.converter);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransformedUnit) {
            TransformedUnit other = (TransformedUnit)obj;
            return Objects.equals(this.parentUnit, other.parentUnit) && Objects.equals(this.converter, other.converter);
        }
        return false;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public Unit<Q> getParentUnit() {
        return this.parentUnit;
    }
}

