/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import tec.uom.se.AbstractUnit;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.function.NaturalOrder;
import tec.uom.se.function.UnitSupplier;
import tec.uom.se.function.ValueSupplier;
import tec.uom.se.quantity.Quantities;

public abstract class AbstractQuantity<Q extends Quantity<Q>>
implements ComparableQuantity<Q>,
UnitSupplier<Q>,
ValueSupplier<Number> {
    private static final long serialVersionUID = 293852425369811882L;
    private final Unit<Q> unit;
    public static final Quantity<Dimensionless> NONE = Quantities.getQuantity(0, AbstractUnit.ONE);
    public static final Quantity<Dimensionless> ONE = Quantities.getQuantity(1, AbstractUnit.ONE);

    protected AbstractQuantity(Unit<Q> unit) {
        this.unit = unit;
    }

    @Override
    public abstract Number getValue();

    @Override
    public Unit<Q> getUnit() {
        return this.unit;
    }

    public Quantity<Q> toSI() {
        return this.to(this.getUnit().getSystemUnit());
    }

    @Override
    public ComparableQuantity<Q> to(Unit<Q> unit) {
        if (unit.equals(this.getUnit())) {
            return this;
        }
        UnitConverter t = this.getUnit().getConverterTo(unit);
        Number convertedValue = t.convert(this.getValue());
        return Quantities.getQuantity(convertedValue, unit);
    }

    public Quantity<Q> to(Unit<Q> unit, MathContext ctx) {
        if (unit.equals(this.getUnit())) {
            return this;
        }
        return Quantities.getQuantity(this.decimalValue(unit, ctx), unit);
    }

    @Override
    public boolean isGreaterThan(Quantity<Q> that) {
        return this.compareTo(that) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Quantity<Q> that) {
        return this.compareTo(that) >= 0;
    }

    @Override
    public boolean isLessThan(Quantity<Q> that) {
        return this.compareTo(that) < 0;
    }

    @Override
    public boolean isLessThanOrEqualTo(Quantity<Q> that) {
        return this.compareTo(that) <= 0;
    }

    @Override
    public boolean isEquivalentTo(Quantity<Q> that) {
        return this.compareTo(that) == 0;
    }

    @Override
    public int compareTo(Quantity<Q> that) {
        NaturalOrder<Quantity<Q>> comparator = new NaturalOrder<Quantity<Q>>();
        return comparator.compare(this, that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractQuantity) {
            AbstractQuantity that = (AbstractQuantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    public boolean equals(AbstractQuantity<Q> that, double epsilon, Unit<Q> epsilonUnit) {
        return Math.abs(this.doubleValue(epsilonUnit) - that.doubleValue(epsilonUnit)) <= epsilon;
    }

    public int hashCode() {
        return Objects.hash(this.getUnit(), this.getValue());
    }

    public abstract boolean isBig();

    public String toString() {
        return String.valueOf(this.getValue()) + " " + String.valueOf(this.getUnit());
    }

    public abstract BigDecimal decimalValue(Unit<Q> var1, MathContext var2) throws ArithmeticException;

    public abstract double doubleValue(Unit<Q> var1) throws ArithmeticException;

    public final int intValue(Unit<Q> unit) throws ArithmeticException {
        long longValue = this.longValue(unit);
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Cannot convert " + longValue + " to int (overflow)");
        }
        return (int)longValue;
    }

    protected long longValue(Unit<Q> unit) throws ArithmeticException {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    protected final float floatValue(Unit<Q> unit) {
        return (float)this.doubleValue(unit);
    }

    @Override
    public <T extends Quantity<T>, E extends Quantity<E>> ComparableQuantity<E> divide(Quantity<T> that, Class<E> asTypeQuantity) {
        return this.divide((Quantity)Objects.requireNonNull(that)).asType((Class)Objects.requireNonNull(asTypeQuantity));
    }

    @Override
    public <T extends Quantity<T>, E extends Quantity<E>> ComparableQuantity<E> multiply(Quantity<T> that, Class<E> asTypeQuantity) {
        return this.multiply((Quantity)Objects.requireNonNull(that)).asType((Class)Objects.requireNonNull(asTypeQuantity));
    }

    @Override
    public <T extends Quantity<T>> ComparableQuantity<T> inverse(Class<T> quantityClass) {
        return this.inverse().asType((Class)quantityClass);
    }

    @Override
    public final <T extends Quantity<T>> ComparableQuantity<T> asType(Class<T> type) throws ClassCastException {
        this.getUnit().asType(type);
        return this;
    }
}

