/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.unit;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractUnit;
import tec.uom.se.quantity.QuantityDimension;

public final class ProductUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 962983585531030093L;
    private final Element[] elements;
    private final String symbol;

    public ProductUnit() {
        this.symbol = "";
        this.elements = new Element[0];
    }

    public ProductUnit(Unit<?> productUnit) {
        this.symbol = productUnit.getSymbol();
        this.elements = ((ProductUnit)productUnit).elements;
    }

    private ProductUnit(Element[] elements) {
        this.elements = elements;
        this.symbol = elements[0].getUnit().getSymbol();
    }

    public static Unit<?> getProductInstance(AbstractUnit<?> left, AbstractUnit<?> right) {
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left).elements : new Element[]{new Element(left, 1, 1)};
        Element[] rightElems = right instanceof ProductUnit ? ((ProductUnit)right).elements : new Element[]{new Element(right, 1, 1)};
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    public static Unit<?> getQuotientInstance(Unit<?> left, Unit<?> right) {
        Element[] rightElems;
        Element[] leftElems = left instanceof ProductUnit ? ((ProductUnit)left).elements : new Element[]{new Element((AbstractUnit)left, 1, 1)};
        if (right instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)right).elements;
            rightElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                rightElems[i] = new Element(elems[i].unit, -elems[i].pow, elems[i].root);
            }
        } else {
            rightElems = new Element[]{new Element((AbstractUnit)right, -1, 1)};
        }
        return ProductUnit.getInstance(leftElems, rightElems);
    }

    public static Unit<?> getRootInstance(AbstractUnit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit).elements;
            unitElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i].pow), elems[i].root * n);
                unitElems[i] = new Element(elems[i].unit, elems[i].pow / gcd, elems[i].root * n / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, 1, n)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    static Unit<?> getPowInstance(AbstractUnit<?> unit, int n) {
        Element[] unitElems;
        if (unit instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)unit).elements;
            unitElems = new Element[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                int gcd = ProductUnit.gcd(Math.abs(elems[i].pow * n), elems[i].root);
                unitElems[i] = new Element(elems[i].unit, elems[i].pow * n / gcd, elems[i].root / gcd);
            }
        } else {
            unitElems = new Element[]{new Element(unit, n, 1)};
        }
        return ProductUnit.getInstance(unitElems, new Element[0]);
    }

    public int getUnitCount() {
        return this.elements.length;
    }

    public AbstractUnit<?> getUnit(int index) {
        return this.elements[index].getUnit();
    }

    public int getUnitPow(int index) {
        return this.elements[index].getPow();
    }

    public int getUnitRoot(int index) {
        return this.elements[index].getRoot();
    }

    @Override
    public Map<AbstractUnit<?>, Integer> getProductUnits() {
        HashMap units = new HashMap();
        for (int i = 0; i < this.getUnitCount(); ++i) {
            units.put(this.getUnit(i), this.getUnitPow(i));
        }
        return units;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProductUnit) {
            Element[] elems = ((ProductUnit)obj).elements;
            if (this.elements.length != elems.length) {
                return false;
            }
            for (Element element : this.elements) {
                boolean unitFound = false;
                for (Element elem : elems) {
                    if (!element.unit.equals(elem.unit)) continue;
                    if (element.pow != elem.pow || element.root != elem.root) {
                        return false;
                    }
                    unitFound = true;
                    break;
                }
                if (unitFound) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.elements);
    }

    @Override
    public AbstractUnit<Q> toSystemUnit() {
        Unit systemUnit = AbstractUnit.ONE;
        for (Element element : this.elements) {
            Unit unit = element.unit.getSystemUnit();
            unit = unit.pow(element.pow);
            unit = unit.root(element.root);
            systemUnit = systemUnit.multiply(unit);
        }
        return systemUnit;
    }

    @Override
    public UnitConverter getConverterToSI() {
        AbstractConverter converter = AbstractConverter.IDENTITY;
        for (Element e : this.elements) {
            UnitConverter cvtr = e.unit.getConverterToSI();
            if (!cvtr.isLinear()) {
                throw new UnsupportedOperationException(e.unit + " is non-linear, cannot convert");
            }
            if (e.root != 1) {
                throw new UnsupportedOperationException(e.unit + " holds a base unit with fractional exponent");
            }
            int pow = e.pow;
            if (pow < 0) {
                pow = -pow;
                cvtr = cvtr.inverse();
            }
            for (int j = 0; j < pow; ++j) {
                converter = converter.concatenate(cvtr);
            }
        }
        return converter;
    }

    @Override
    public Dimension getDimension() {
        Dimension dimension = QuantityDimension.NONE;
        for (int i = 0; i < this.getUnitCount(); ++i) {
            AbstractUnit<?> unit = this.getUnit(i);
            if (this.elements == null || unit.getDimension() == null) continue;
            Dimension d = unit.getDimension().pow(this.getUnitPow(i)).root(this.getUnitRoot(i));
            dimension = dimension.multiply(d);
        }
        return dimension;
    }

    private static Unit<?> getInstance(Element[] leftElems, Element[] rightElems) {
        AbstractUnit unit;
        Element[] result = new Element[leftElems.length + rightElems.length];
        int resultIndex = 0;
        for (Element leftElem : leftElems) {
            unit = leftElem.unit;
            int p1 = leftElem.pow;
            int r1 = leftElem.root;
            int p2 = 0;
            int r2 = 1;
            for (Element rightElem : rightElems) {
                if (!unit.equals(rightElem.unit)) continue;
                p2 = rightElem.pow;
                r2 = rightElem.root;
                break;
            }
            int pow = p1 * r2 + p2 * r1;
            int root = r1 * r2;
            if (pow == 0) continue;
            int gcd = ProductUnit.gcd(Math.abs(pow), root);
            result[resultIndex++] = new Element(unit, pow / gcd, root / gcd);
        }
        for (Element rightElem : rightElems) {
            unit = rightElem.unit;
            boolean hasBeenMerged = false;
            for (Element leftElem : leftElems) {
                if (!unit.equals(leftElem.unit)) continue;
                hasBeenMerged = true;
                break;
            }
            if (hasBeenMerged) continue;
            result[resultIndex++] = rightElem;
        }
        if (resultIndex == 0) {
            return AbstractUnit.ONE;
        }
        if (resultIndex == 1 && result[0].pow == result[0].root) {
            return result[0].unit;
        }
        Element[] elems = new Element[resultIndex];
        System.arraycopy(result, 0, elems, 0, resultIndex);
        return new ProductUnit(elems);
    }

    private static int gcd(int m, int n) {
        if (n == 0) {
            return m;
        }
        return ProductUnit.gcd(n, m % n);
    }

    public String getSymbol() {
        return this.symbol;
    }

    private static final class Element {
        private final AbstractUnit<?> unit;
        private final int pow;
        private final int root;

        private Element(AbstractUnit<?> unit, int pow, int root) {
            this.unit = unit;
            this.pow = pow;
            this.root = root;
        }

        public AbstractUnit<?> getUnit() {
            return this.unit;
        }

        public int getPow() {
            return this.pow;
        }

        public int getRoot() {
            return this.root;
        }
    }
}

