/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.unit;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.UnitConverter;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractUnit;
import tec.uom.se.quantity.QuantityDimension;

public final class BaseUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 1721629233768215930L;
    private final String symbol;
    private final Dimension dimension;

    public BaseUnit(String symbol, Dimension dimension) {
        this.symbol = symbol;
        this.dimension = dimension;
    }

    public BaseUnit(String symbol) {
        this.symbol = symbol;
        this.dimension = QuantityDimension.NONE;
    }

    public BaseUnit(String symbol, String name) {
        this(symbol);
        this.name = name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public AbstractUnit<Q> toSystemUnit() {
        return this;
    }

    @Override
    public UnitConverter getConverterToSI() throws UnsupportedOperationException {
        return AbstractConverter.IDENTITY;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof BaseUnit)) {
            return false;
        }
        BaseUnit thatUnit = (BaseUnit)that;
        return this.symbol.equals(thatUnit.symbol) && this.dimension.equals(thatUnit.dimension);
    }

    @Override
    public final int hashCode() {
        return this.symbol.hashCode();
    }

    @Override
    public Map<? extends AbstractUnit<Q>, Integer> getProductUnits() {
        return null;
    }
}

