/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.quantity;

import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.quantity.NumberQuantity;

final class LongQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    final long value;

    public LongQuantity(long value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? (double)this.value : super.getUnit().getConverterTo(unit).convert((double)this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    public Quantity<Q> add(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value + converted.getValue().longValue(), this.getUnit());
    }

    public Quantity<Q> subtract(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value - converted.getValue().longValue(), this.getUnit());
    }

    public Quantity<?> multiply(Quantity<?> that) {
        return new LongQuantity(this.value * that.getValue().longValue(), this.getUnit());
    }

    public Quantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.value * (long)that.intValue(), this.getUnit());
    }

    public Quantity<?> divide(Quantity<?> that) {
        return NumberQuantity.of((double)this.value / that.getValue().doubleValue(), this.getUnit().divide(that.getUnit()));
    }

    public AbstractQuantity<Q> inverse() {
        return NumberQuantity.of(1L / this.value, this.getUnit().inverse());
    }

    public Quantity<Q> divide(Number that) {
        return NumberQuantity.of((double)this.value / that.doubleValue(), this.getUnit());
    }
}

