/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import tec.units.ri.AbstractUnit;
import tec.units.ri.format.QuantityFormat;
import tec.units.ri.function.NaturalOrder;
import tec.units.ri.quantity.NumberQuantity;
import tec.uom.lib.common.function.UnitSupplier;
import tec.uom.lib.common.function.ValueSupplier;

public abstract class AbstractQuantity<Q extends Quantity<Q>>
implements Quantity<Q>,
Comparable<Quantity<Q>>,
UnitSupplier<Q>,
ValueSupplier<Number> {
    private final Unit<Q> unit;
    public static final Quantity<Dimensionless> NONE = NumberQuantity.of(0, AbstractUnit.ONE);
    public static final Quantity<Dimensionless> ONE = NumberQuantity.of(1, AbstractUnit.ONE);

    protected AbstractQuantity(Unit<Q> unit) {
        this.unit = unit;
    }

    public abstract Number getValue();

    public Unit<Q> getUnit() {
        return this.unit;
    }

    public Quantity<Q> toSI() {
        return this.to(this.getUnit().getSystemUnit());
    }

    public Quantity<Q> to(Unit<Q> unit) {
        if (unit.equals(this.getUnit())) {
            return this;
        }
        return NumberQuantity.of(this.doubleValue(unit), unit);
    }

    @Override
    public int compareTo(Quantity<Q> that) {
        NaturalOrder<Quantity<Q>> comparator = new NaturalOrder<Quantity<Q>>();
        return comparator.compare(this, that);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractQuantity)) {
            return false;
        }
        AbstractQuantity that = (AbstractQuantity)obj;
        return this.getUnit().equals(that.getUnit()) && this.getValue().equals(that.getValue());
    }

    public boolean equals(AbstractQuantity<Q> that, double epsilon, Unit<Q> epsilonUnit) {
        return Math.abs(this.doubleValue(epsilonUnit) - that.doubleValue(epsilonUnit)) <= epsilon;
    }

    public int hashCode() {
        return this.getUnit().hashCode() + this.getValue().hashCode();
    }

    final boolean isBig() {
        return false;
    }

    public String toString() {
        return QuantityFormat.getInstance().format(this);
    }

    public abstract double doubleValue(Unit<Q> var1) throws ArithmeticException;

    protected long longValue(Unit<Q> unit) throws ArithmeticException {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    protected float floatValue(Unit<Q> unit) {
        return (float)this.doubleValue(unit);
    }

    public final <T extends Quantity<T>> Quantity<T> asType(Class<T> type) throws ClassCastException {
        this.getUnit().asType(type);
        return this;
    }

    public static Quantity<?> parse(CharSequence csq) {
        return (Quantity)QuantityFormat.getInstance().parse(csq);
    }
}

