/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.spi;

import tec.units.ri.function.MaximumSupplier;
import tec.units.ri.function.MinimumSupplier;

public abstract class Range<T>
implements MinimumSupplier<T>,
MaximumSupplier<T> {
    private final T min;
    private final T max;

    protected Range(T min, T max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public T getMinimum() {
        return this.min;
    }

    @Override
    public T getMaximum() {
        return this.max;
    }

    public boolean hasMinimum() {
        return this.min != null;
    }

    public boolean hasMaximum() {
        return this.max != null;
    }

    public abstract boolean contains(T var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        return !(this.min == null ? other.min != null : !this.min.equals(other.min));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("min= ").append(this.getMinimum()).append(", max= ").append(this.getMaximum());
        return sb.toString();
    }
}

