/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.spi.ServiceProvider;

public class RIServiceProvider
implements ServiceProvider {
    private final Map<Class, List<Object>> servicesLoaded = new HashMap<Class, List<Object>>();

    public int getPriority() {
        return 10;
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        return this.loadServices(serviceType);
    }

    public <T> T getService(Class<T> serviceType) {
        List<T> servicesFound = this.getServices(serviceType);
        if (servicesFound.isEmpty()) {
            return null;
        }
        return servicesFound.get(0);
    }

    private <T> List<T> loadServices(Class<T> serviceType) {
        ArrayList<T> services = new ArrayList<T>();
        try {
            for (T t : ServiceLoader.load(serviceType)) {
                services.add(t);
            }
            if (!this.servicesLoaded.containsKey(serviceType)) {
                ArrayList<T> previousServices = this.servicesLoaded.put(serviceType, services);
                return previousServices != null ? previousServices : services;
            }
            return services;
        }
        catch (Exception e) {
            Logger.getLogger(RIServiceProvider.class.getName()).log(Level.WARNING, "Error loading services of type " + serviceType, e);
            return services;
        }
    }
}

