/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.function;

import tec.units.ri.AbstractConverter;
import tec.units.ri.function.ExpConverter;
import tec.units.ri.function.ValueSupplier;
import tec.units.ri.internal.MathUtil;

public final class LogConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private double base;
    private double logOfBase;

    public LogConverter(double base) {
        this.base = base;
        this.logOfBase = MathUtil.log(base);
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public AbstractConverter inverse() {
        return new ExpConverter(this.base);
    }

    public final String toString() {
        if (this.base == Math.E) {
            return "ln";
        }
        return "Log(" + this.base + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LogConverter)) {
            return false;
        }
        LogConverter that = (LogConverter)obj;
        return this.base == that.base;
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.base);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public double convert(double amount) {
        return MathUtil.log(amount) / this.logOfBase;
    }

    public boolean isLinear() {
        return false;
    }

    @Override
    public String getValue() {
        return this.toString();
    }
}

