/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.spi.ServiceProvider;

class DefaultServiceProvider
implements ServiceProvider {
    private final ConcurrentHashMap<Class, List<Object>> servicesLoaded = new ConcurrentHashMap();

    DefaultServiceProvider() {
    }

    public int getPriority() {
        return 0;
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        return this.loadServices(serviceType);
    }

    public <T> T getService(Class<T> serviceType) {
        List<T> servicesFound = this.getServices(serviceType);
        if (servicesFound.isEmpty()) {
            return null;
        }
        return servicesFound.get(0);
    }

    private <T> List<T> loadServices(Class<T> serviceType) {
        ArrayList<T> services = new ArrayList<T>();
        try {
            for (T t : ServiceLoader.load(serviceType)) {
                services.add(t);
            }
            ArrayList<T> previousServices = this.servicesLoaded.putIfAbsent(serviceType, services);
            return Collections.unmodifiableList(previousServices != null ? previousServices : services);
        }
        catch (Exception e) {
            Logger.getLogger(DefaultServiceProvider.class.getName()).log(Level.WARNING, "Error loading services of type " + serviceType, e);
            return services;
        }
    }
}

