/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.quantity;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.format.FormatBehavior;
import tec.units.ri.format.QuantityFormat;
import tec.units.ri.quantity.DoubleQuantity;
import tec.units.ri.quantity.FloatQuantity;
import tec.units.ri.quantity.IntegerQuantity;
import tec.units.ri.quantity.LongQuantity;

public class NumberQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private final Number value;
    private final boolean isExact;

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() == obj.getClass()) {
            return super.equals(obj);
        }
        if (obj instanceof Quantity) {
            Quantity m = (Quantity)obj;
            if (m.getValue().getClass() == this.getValue().getClass() && m.getUnit().getClass() == this.getUnit().getClass()) {
                return super.equals(obj);
            }
            return super.equals(obj);
        }
        return false;
    }

    public NumberQuantity(Number number, Unit<Q> unit) {
        super(unit);
        this.value = number;
        this.isExact = false;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        Unit myUnit = this.getUnit();
        UnitConverter converter = unit.getConverterTo(myUnit);
        return converter.convert(this.getValue().doubleValue());
    }

    @Override
    protected final long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    protected final int intValue(Unit<Q> unit) throws ArithmeticException {
        long longValue = this.longValue(unit);
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new ArithmeticException("Cannot convert " + longValue + " to int (overflow)");
        }
        return (int)longValue;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    public boolean isExact() {
        return this.isExact;
    }

    public NumberQuantity<Q> add(AbstractQuantity<Q> that) {
        Quantity thatToUnit = that.to(this.getUnit());
        return new NumberQuantity(this.getValue().doubleValue() + thatToUnit.getValue().doubleValue(), this.getUnit());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getValue()) + " " + String.valueOf(this.getUnit());
    }

    public Quantity<?> multiply(Quantity<?> that) {
        Unit unit = this.getUnit().multiply(that.getUnit());
        return new NumberQuantity<Q>(this.getValue().doubleValue() * that.getValue().doubleValue(), unit);
    }

    public NumberQuantity<Q> multiply(Number that) {
        return (NumberQuantity)NumberQuantity.of(this.getValue().doubleValue() * that.doubleValue(), this.getUnit());
    }

    public Quantity<Q> divide(Quantity<?> that) {
        Unit unit = this.getUnit().divide(that.getUnit());
        return new NumberQuantity<Q>(this.getValue().doubleValue() / that.getValue().doubleValue(), unit);
    }

    public Quantity<Q> divide(Number that) {
        return NumberQuantity.of(this.getValue().doubleValue() / that.doubleValue(), this.getUnit());
    }

    public Quantity<Q> inverse() {
        NumberQuantity<Q> m = new NumberQuantity<Q>(1.0 / this.getValue().doubleValue(), this.getUnit().inverse());
        return m;
    }

    @Override
    public int compareTo(Quantity<Q> o) {
        return 0;
    }

    public Quantity<Q> subtract(Quantity<Q> that) {
        Quantity thatToUnit = that.to(this.getUnit());
        return new NumberQuantity(this.getValue().doubleValue() - thatToUnit.getValue().doubleValue(), this.getUnit());
    }

    public Quantity<Q> add(Quantity<Q> that) {
        Quantity thatToUnit = that.to(this.getUnit());
        return new NumberQuantity(this.getValue().doubleValue() + thatToUnit.getValue().doubleValue(), this.getUnit());
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(long longValue, Unit<Q> unit) {
        return new LongQuantity<Q>(longValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(int intValue, Unit<Q> unit) {
        return new IntegerQuantity<Q>(intValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(float floatValue, Unit<Q> unit) {
        return new FloatQuantity<Q>(floatValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(double doubleValue, Unit<Q> unit) {
        return new DoubleQuantity<Q>(doubleValue, unit);
    }

    public static Quantity<?> parse(CharSequence csq) {
        try {
            return (Quantity)QuantityFormat.getInstance(FormatBehavior.LOCALE_NEUTRAL).parse(csq);
        }
        catch (IllegalArgumentException ie) {
            throw ie;
        }
        catch (ParserException pe) {
            throw new IllegalArgumentException(pe);
        }
    }
}

