/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.quantity;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.QuantityFactory;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.quantity.NumberQuantity;
import tec.units.ri.unit.Units;

abstract class AbstractQuantityFactory<Q extends Quantity<Q>>
implements QuantityFactory<Q> {
    static final Map<Class, AbstractQuantityFactory> INSTANCES = new HashMap<Class, AbstractQuantityFactory>();
    static final Logger logger = Logger.getLogger(AbstractQuantityFactory.class.getName());
    static final Level LOG_LEVEL = Level.FINE;

    AbstractQuantityFactory() {
    }

    protected static <Q extends Quantity<Q>> void setInstance(Class<Q> type, AbstractQuantityFactory<Q> factory) {
        if (!AbstractQuantity.class.isAssignableFrom(type)) {
            throw new ClassCastException();
        }
        INSTANCES.put(type, factory);
    }

    public abstract Quantity<Q> create(Number var1, Unit<Q> var2);

    public abstract Unit<Q> getMetricUnit();

    private static final class Default<Q extends Quantity<Q>>
    extends AbstractQuantityFactory<Q> {
        private final Class<Q> type;
        private final Unit<Q> metricUnit;
        static final Map<Class, Unit> CLASS_TO_METRIC_UNIT = new HashMap<Class, Unit>();

        Default(Class<Q> type) {
            this.type = type;
            this.metricUnit = CLASS_TO_METRIC_UNIT.get(type);
        }

        @Override
        public Quantity<Q> create(Number value, Unit<Q> unit) {
            return new NumberQuantity<Q>(value, unit);
        }

        @Override
        public Unit<Q> getMetricUnit() {
            return this.metricUnit;
        }

        static {
            CLASS_TO_METRIC_UNIT.put(Dimensionless.class, Units.ONE);
            CLASS_TO_METRIC_UNIT.put(ElectricCurrent.class, Units.AMPERE);
            CLASS_TO_METRIC_UNIT.put(LuminousIntensity.class, Units.CANDELA);
            CLASS_TO_METRIC_UNIT.put(Temperature.class, Units.KELVIN);
            CLASS_TO_METRIC_UNIT.put(Mass.class, Units.KILOGRAM);
            CLASS_TO_METRIC_UNIT.put(Length.class, Units.METRE);
            CLASS_TO_METRIC_UNIT.put(AmountOfSubstance.class, Units.MOLE);
            CLASS_TO_METRIC_UNIT.put(Time.class, Units.SECOND);
            CLASS_TO_METRIC_UNIT.put(Angle.class, Units.RADIAN);
            CLASS_TO_METRIC_UNIT.put(SolidAngle.class, Units.STERADIAN);
            CLASS_TO_METRIC_UNIT.put(Frequency.class, Units.HERTZ);
            CLASS_TO_METRIC_UNIT.put(Force.class, Units.NEWTON);
            CLASS_TO_METRIC_UNIT.put(Pressure.class, Units.PASCAL);
            CLASS_TO_METRIC_UNIT.put(Energy.class, Units.JOULE);
            CLASS_TO_METRIC_UNIT.put(Power.class, Units.WATT);
            CLASS_TO_METRIC_UNIT.put(ElectricCharge.class, Units.COULOMB);
            CLASS_TO_METRIC_UNIT.put(ElectricPotential.class, Units.VOLT);
            CLASS_TO_METRIC_UNIT.put(ElectricCapacitance.class, Units.FARAD);
            CLASS_TO_METRIC_UNIT.put(ElectricResistance.class, Units.OHM);
            CLASS_TO_METRIC_UNIT.put(ElectricConductance.class, Units.SIEMENS);
            CLASS_TO_METRIC_UNIT.put(MagneticFlux.class, Units.WEBER);
            CLASS_TO_METRIC_UNIT.put(MagneticFluxDensity.class, Units.TESLA);
            CLASS_TO_METRIC_UNIT.put(ElectricInductance.class, Units.HENRY);
            CLASS_TO_METRIC_UNIT.put(LuminousFlux.class, Units.LUMEN);
            CLASS_TO_METRIC_UNIT.put(Illuminance.class, Units.LUX);
            CLASS_TO_METRIC_UNIT.put(Radioactivity.class, Units.BECQUEREL);
            CLASS_TO_METRIC_UNIT.put(RadiationDoseAbsorbed.class, Units.GRAY);
            CLASS_TO_METRIC_UNIT.put(RadiationDoseEffective.class, Units.SIEVERT);
            CLASS_TO_METRIC_UNIT.put(CatalyticActivity.class, Units.KATAL);
            CLASS_TO_METRIC_UNIT.put(Speed.class, Units.METRES_PER_SECOND);
            CLASS_TO_METRIC_UNIT.put(Acceleration.class, Units.METRES_PER_SQUARE_SECOND);
            CLASS_TO_METRIC_UNIT.put(Area.class, Units.SQUARE_METRE);
            CLASS_TO_METRIC_UNIT.put(Volume.class, Units.CUBIC_METRE);
        }
    }
}

