/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.internal.format.l10n;

import java.util.logging.Level;
import java.util.logging.Logger;
import tec.units.ri.internal.format.l10n.DigitList;
import tec.units.ri.internal.format.l10n.NumberFormatSymbols;

public class NumberFormat {
    private static final Logger logging = Logger.getLogger(NumberFormat.class.getName());
    private static final String COMMA = ",";
    private static final String PERIOD = ".";
    private static final char DASH = '-';
    private static final char LEFT_PAREN = '(';
    private static final char RIGHT_PAREN = ')';
    private static final String THOUSAND = "k";
    private static final String MILLION = "m";
    private static final String BILLION = "b";
    private static final int CUR_POS_LEFT_OUTSIDE = 0;
    private static final int CUR_POS_LEFT_INSIDE = 1;
    private static final int CUR_POS_RIGHT_INSIDE = 2;
    private static final int CUR_POS_RIGHT_OUTSIDE = 3;
    private static final int NEG_LEFT_DASH = 0;
    private static final int NEG_RIGHT_DASH = 1;
    private static final int NEG_PARENTHESIS = 2;
    private static final int ARBITRARY_PRECISION = -1;
    private String inputDecimalSeparator = ".";
    private boolean showGrouping = true;
    private String groupingSeparator = ",";
    private String decimalSeparator = ".";
    private boolean showCurrencySymbol = false;
    private String currencySymbol = "$";
    private int currencySymbolPosition = 0;
    private int negativeFormat = 0;
    private boolean isNegativeRed = false;
    private int decimalPrecision = 0;
    private boolean useFixedPrecision = false;
    private boolean truncate = false;
    private boolean isPercentage = false;
    private static final String classname = NumberFormat.class.getName();
    private static final int DOUBLE_INTEGER_DIGITS = 309;
    private static final int DOUBLE_FRACTION_DIGITS = 340;
    public static final char NONLOCALIZED_PERCENT_SIGN = '%';
    public static final char UNICODE_INFINITY = '\u221e';
    public static final int NUMBERSTYLE = 0;
    public static final int CURRENCYSTYLE = 1;
    public static final int PERCENTSTYLE = 2;
    public static final int INTEGERSTYLE = 3;
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private NumberFormatSymbols symbols;
    private boolean isCurrencyFormat = false;
    private boolean isPercentageFormat = false;
    private DigitList digitList = new DigitList();
    private int style = 0;

    public NumberFormat(int style, NumberFormatSymbols symbols) {
        this.style = style;
        this.symbols = symbols;
        this.isCurrencyFormat = style == 1;
        this.isPercentageFormat = style == 2;
        this.applySymbols();
        if (logging.getLevel().intValue() <= Level.INFO.intValue()) {
            logging.log(Level.INFO, classname + ": " + "NumberFormat created\n" + "style is " + style + "\n" + "symbols is " + symbols);
        }
    }

    public static final NumberFormat getInstance() {
        return new NumberFormat(0, new NumberFormatSymbols());
    }

    public void setMaximumFractionDigits(int count) {
        if (this.symbols != null && count <= 340 && count >= 0 && this.style != 3) {
            this.symbols.maximumFractionDigits[this.style] = count;
            if (this.symbols.minimumFractionDigits[this.style] < count) {
                this.symbols.minimumFractionDigits[this.style] = count;
            }
        }
    }

    public int getMaximumFractionDigits() {
        return this.symbols != null ? this.symbols.maximumFractionDigits[this.style] : -1;
    }

    public void setMinimumFractionDigits(int count) {
        if (this.symbols != null && count >= 0 && this.style != 3) {
            this.symbols.minimumFractionDigits[this.style] = count;
            if (count > this.symbols.maximumFractionDigits[this.style]) {
                this.symbols.maximumFractionDigits[this.style] = count;
            }
        }
    }

    public void setMultiplier(int multiplier) {
        if (this.symbols != null) {
            this.symbols.multiplier[this.style] = multiplier;
        }
    }

    public int getMultiplier() {
        return this.symbols != null ? this.symbols.multiplier[this.style] : 1;
    }

    public void setGroupingUsed(boolean used) {
        if (this.symbols != null) {
            this.symbols.groupingUsed = used;
        }
    }

    public int getMinimumFractionDigits() {
        return this.symbols != null ? this.symbols.minimumFractionDigits[this.style] : -1;
    }

    public void setMinimumIntegerDigits(int count) {
        if (this.symbols != null && count > 0) {
            this.symbols.minimumIntegerDigits[this.style] = count;
        }
    }

    public int getMinimumIntegerDigits() {
        return this.symbols != null ? this.symbols.minimumIntegerDigits[this.style] : -1;
    }

    public String setCurrencySymbol(String symbol) {
        String oldsymbol = null;
        if (this.isCurrencyFormat && this.symbols != null) {
            oldsymbol = this.symbols.currencySymbol;
            if (!symbol.equals(this.symbols.currencySymbol)) {
                this.symbols.currencySymbol = symbol;
                this.symbols.suffixes[this.style] = this.replSubStr(this.symbols.suffixes[this.style], oldsymbol, symbol);
                this.symbols.prefixes[this.style] = this.replSubStr(this.symbols.prefixes[this.style], oldsymbol, symbol);
                this.symbols.negativeSuffix[this.style] = this.replSubStr(this.symbols.negativeSuffix[this.style], oldsymbol, symbol);
                this.symbols.negativePrefix[this.style] = this.replSubStr(this.symbols.negativePrefix[this.style], oldsymbol, symbol);
                this.symbols.positiveSuffix[this.style] = this.replSubStr(this.symbols.positiveSuffix[this.style], oldsymbol, symbol);
                this.symbols.positivePrefix[this.style] = this.replSubStr(this.symbols.positivePrefix[this.style], oldsymbol, symbol);
            }
        }
        return oldsymbol;
    }

    private String replSubStr(String str, String oldVal, String newVal) {
        int pos;
        String res = str;
        if (str.length() > 0 && (pos = str.indexOf(oldVal)) >= 0) {
            res = str.substring(0, pos);
            res = res.concat(newVal);
            res = res.concat(str.substring(pos + oldVal.length()));
            return res;
        }
        return res;
    }

    public String getCurrencySymbolForCode(String currencyCode) {
        if (this.symbols != null && this.symbols.currencies != null) {
            for (int i = 0; i < this.symbols.currencies.length; ++i) {
                if (this.symbols.currencies[i].length <= 0 || !this.symbols.currencies[i][0].equals(currencyCode)) continue;
                if (this.symbols.currencies[i].length > 1) {
                    return this.symbols.currencies[i][1];
                }
                return null;
            }
        }
        return null;
    }

    private void applySymbols() {
        if (this.symbols != null) {
            if (this.symbols.maximumIntegerDigits[this.style] == -1) {
                this.symbols.maximumIntegerDigits[this.style] = 309;
            }
            if (this.symbols.maximumFractionDigits[this.style] == -1) {
                this.symbols.maximumFractionDigits[this.style] = 340;
            }
        }
    }

    public String format(long value) {
        return this.format(new Long(value));
    }

    public String format(double value) {
        if (this.symbols != null) {
            if (Double.isNaN(value)) {
                return this.symbols.NaN;
            }
            if (Double.isInfinite(value)) {
                String prefix = value > 0.0 ? "" : this.symbols.negativePrefix[this.style];
                String suffix = value > 0.0 ? "" : this.symbols.negativeSuffix[this.style];
                return prefix + this.symbols.infinity + suffix;
            }
        } else {
            if (Double.isNaN(value)) {
                return "NaN";
            }
            if (Double.isInfinite(value)) {
                String prefix = value > 0.0 ? "" : "-";
                return prefix + '\u221e';
            }
        }
        return this.format(new Double(value));
    }

    public String format(int value) {
        return this.format(new Long(value));
    }

    public String format(float value) {
        return this.format((double)value);
    }

    public String format(Object o) {
        StringBuffer appendTo = new StringBuffer();
        if (o == null) {
            return "";
        }
        if (this.symbols != null) {
            if (o instanceof Double) {
                this.format((Double)o, appendTo);
            }
            if (o instanceof Long) {
                this.format((Long)o, appendTo);
            }
        } else if (this.isPercentageFormat) {
            if (o instanceof Double) {
                appendTo.append(Double.toString((Double)o * 100.0));
            } else if (o instanceof Long) {
                long value = (Long)o;
                appendTo.append(Long.toString(value));
                if (value != 0L) {
                    appendTo.append("00");
                }
            }
            appendTo.append('%');
        } else {
            return o.toString();
        }
        return appendTo.toString();
    }

    private StringBuffer format(double number, StringBuffer result) {
        boolean isNegative;
        if (Double.isNaN(number)) {
            result.append(this.symbols.NaN);
            return result;
        }
        boolean bl = isNegative = number < 0.0 || number == 0.0 && 1.0 / number < 0.0;
        if (isNegative) {
            number = -number;
        }
        if (this.symbols.multiplier[this.style] != 1) {
            number *= (double)this.symbols.multiplier[this.style];
        }
        if (Double.isInfinite(number)) {
            if (isNegative) {
                result.append(this.symbols.negativePrefix[this.style]);
            } else {
                result.append(this.symbols.positivePrefix[this.style]);
            }
            result.append(this.symbols.infinity);
            if (isNegative) {
                result.append(this.symbols.negativeSuffix[this.style]);
            } else {
                result.append(this.symbols.positiveSuffix[this.style]);
            }
            return result;
        }
        this.digitList.set(number, this.symbols.maximumFractionDigits[this.style]);
        result = this.subformat(result, isNegative, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(long number, StringBuffer result) {
        boolean isNegative;
        boolean bl = isNegative = number < 0L;
        if (isNegative) {
            number = -number;
        }
        if (this.symbols.multiplier[this.style] != 1 && this.symbols.multiplier[this.style] != 0) {
            long cutoff;
            boolean useDouble = false;
            if (number < 0L) {
                cutoff = Long.MIN_VALUE / (long)this.symbols.multiplier[this.style];
                useDouble = number < cutoff;
            } else {
                cutoff = Long.MAX_VALUE / (long)this.symbols.multiplier[this.style];
                boolean bl2 = useDouble = number > cutoff;
            }
            if (useDouble) {
                double dnumber = isNegative ? -number : number;
                return this.format(dnumber, result);
            }
        }
        number *= (long)this.symbols.multiplier[this.style];
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(number, 0);
            return this.subformat(result, isNegative, true);
        }
    }

    private StringBuffer subformat(StringBuffer result, boolean isNegative, boolean isInteger) {
        boolean fractionPresent;
        char decimal;
        char zero = this.symbols.zeroDigit;
        int zeroDelta = zero - 48;
        char grouping = this.symbols.groupingSeparator;
        char c = decimal = this.isCurrencyFormat ? this.symbols.monetarySeparator : this.symbols.decimalSeparator;
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        int fieldStart = result.length();
        if (isNegative) {
            result.append(this.symbols.negativePrefix[this.style]);
        } else {
            result.append(this.symbols.positivePrefix[this.style]);
        }
        String prefix = this.symbols.prefixes[this.style];
        result.append(prefix);
        int count = this.symbols.minimumIntegerDigits[this.style];
        int digitIndex = 0;
        if (this.digitList.decimalAt > 0 && count < this.digitList.decimalAt) {
            count = this.digitList.decimalAt;
        }
        if (count > this.symbols.maximumIntegerDigits[this.style]) {
            count = this.symbols.maximumIntegerDigits[this.style];
            digitIndex = this.digitList.decimalAt - count;
        }
        if (logging.getLevel().intValue() <= Level.INFO.intValue()) {
            logging.log(Level.INFO, classname + " :" + "grouping used " + this.symbols.groupingUsed + "\n" + "grouping separator \"" + grouping + "\"\n" + "decimal separator \"" + decimal + "\"\n" + "digit count " + count);
        }
        int sizeBeforeIntegerPart = result.length();
        for (int i = count - 1; i >= 0; --i) {
            if (i < this.digitList.decimalAt && digitIndex < this.digitList.count) {
                result.append((char)(this.digitList.digits[digitIndex++] + zeroDelta));
            } else {
                result.append(zero);
            }
            if (!this.symbols.groupingUsed || i <= 0 || this.symbols.groupingCount == 0 || i % this.symbols.groupingCount != 0) continue;
            int gStart = result.length();
            result.append(grouping);
            if (logging.getLevel().intValue() > Level.INFO.intValue()) continue;
            logging.log(Level.INFO, classname + ": " + "add grouping at " + (digitIndex - 1));
        }
        boolean bl = fractionPresent = this.symbols.minimumFractionDigits[this.style] > 0 || !isInteger && digitIndex < this.digitList.count;
        if (!fractionPresent && result.length() == sizeBeforeIntegerPart) {
            result.append(zero);
        }
        int sStart = result.length();
        if (this.symbols.decimalSeparatorAlwaysShown || fractionPresent) {
            result.append(decimal);
        }
        for (int i = 0; i < this.symbols.maximumFractionDigits[this.style] && (i < this.symbols.minimumFractionDigits[this.style] || !isInteger && digitIndex < this.digitList.count); ++i) {
            if (-1 - i > this.digitList.decimalAt - 1) {
                result.append(zero);
                continue;
            }
            if (!isInteger && digitIndex < this.digitList.count) {
                result.append((char)(this.digitList.digits[digitIndex++] + zeroDelta));
                continue;
            }
            result.append(zero);
        }
        String suffix = this.symbols.suffixes[this.style];
        result.append(suffix);
        if (isNegative) {
            result.append(this.symbols.negativeSuffix[this.style]);
        } else {
            result.append(this.symbols.positiveSuffix[this.style]);
        }
        return result;
    }

    private static double subparse(String val, String inputDecimalValue) {
        Double parsed;
        String newVal = val;
        boolean isPercentage = false;
        if (newVal.indexOf(37) != -1) {
            newVal = newVal.replaceAll("\\%", "");
            isPercentage = true;
        }
        newVal = newVal.toLowerCase().replaceAll(BILLION, "000000000");
        newVal = newVal.replaceAll(MILLION, "000000");
        newVal = newVal.replaceAll(THOUSAND, "000");
        String re = "[^\\" + inputDecimalValue + "\\d\\-\\+\\(\\)eE]";
        int index = (newVal = newVal.replaceAll(re, "")).indexOf(inputDecimalValue);
        if (index != -1) {
            newVal = newVal.substring(0, index) + PERIOD + newVal.substring(index + inputDecimalValue.length()).replaceAll("\\" + inputDecimalValue, "");
        }
        if (newVal.charAt(newVal.length() - 1) == '-') {
            newVal = newVal.substring(0, newVal.length() - 1);
            newVal = '-' + newVal;
        } else if (newVal.charAt(0) == '(' && newVal.charAt(newVal.length() - 1) == ')') {
            newVal = newVal.substring(1, newVal.length() - 1);
            newVal = '-' + newVal;
        }
        try {
            parsed = new Double(newVal);
            if (parsed.isInfinite() || parsed.isNaN()) {
                parsed = new Double(0.0);
            }
        }
        catch (NumberFormatException e) {
            parsed = new Double(0.0);
        }
        return isPercentage ? parsed / 100.0 : parsed;
    }

    public double parse(String text) {
        return NumberFormat.subparse(text, this.inputDecimalSeparator);
    }

    public static double parseDouble(String num, String decimalChar) {
        return NumberFormat.subparse(num, decimalChar);
    }

    public static double parseDouble(String num) {
        return NumberFormat.parseDouble(num, PERIOD);
    }
}

