/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.internal.format.l10n;

public class Locale {
    public static final Locale ROOT = new Locale("", "");
    private String language;
    private String country;
    private static Locale defaultLocale;

    public Locale(String language, String country) {
        this.language = language;
        this.country = country;
        defaultLocale = null;
    }

    public Locale(String locale) {
        defaultLocale = null;
        if (locale == null) {
            this.language = "en";
            this.country = "US";
            return;
        }
        this.language = locale;
        this.country = "";
        int separatorPos = (locale = locale.replace('-', '_')).indexOf(95);
        if (separatorPos != -1) {
            this.language = locale.substring(0, separatorPos);
            this.country = (separatorPos = (locale = locale.substring(separatorPos + 1)).indexOf(95)) != -1 ? locale.substring(0, separatorPos) : locale;
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public static Locale getDefault() {
        if (defaultLocale == null) {
            defaultLocale = new Locale("en");
        }
        return defaultLocale;
    }

    public String toString() {
        if (this.language.equals("") && this.country.equals("")) {
            return "";
        }
        StringBuffer localeString = new StringBuffer("");
        if (!this.country.equals("")) {
            localeString.append(this.language).append("_").append(this.country);
        } else if (!this.language.equals("")) {
            localeString.append(this.language);
        }
        return localeString.toString();
    }
}

