/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.internal.format;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.format.UnitFormat;
import javax.measure.spi.UnitFormatService;
import tec.units.ri.format.SimpleUnitFormat;

public class DefaultUnitFormatService
implements UnitFormatService {
    private static final String DEFAULT_FORMAT = SimpleUnitFormat.Flavor.Default.name();
    private Map<String, UnitFormat> formats = new HashMap<String, UnitFormat>();

    public DefaultUnitFormatService() {
        this.formats.put(DEFAULT_FORMAT, SimpleUnitFormat.getInstance());
        this.formats.put(SimpleUnitFormat.Flavor.ASCII.name(), SimpleUnitFormat.getInstance(SimpleUnitFormat.Flavor.ASCII));
    }

    public UnitFormat getUnitFormat(String formatName) {
        Objects.requireNonNull(formatName, "Format name required");
        return this.formats.get(formatName);
    }

    public UnitFormat getUnitFormat() {
        return this.getUnitFormat(DEFAULT_FORMAT);
    }

    public Set<String> getAvailableFormatNames() {
        return this.formats.keySet();
    }
}

