/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.function;

import tec.units.ri.AbstractConverter;
import tec.units.ri.function.PiDivisorConverter;
import tec.units.ri.function.ValueSupplier;

public final class PiMultiplierConverter
extends AbstractConverter
implements ValueSupplier<String> {
    @Override
    public double convert(double value) {
        return value * Math.PI;
    }

    @Override
    public AbstractConverter inverse() {
        return new PiDivisorConverter();
    }

    public final String toString() {
        return "(\u03c0)";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PiMultiplierConverter;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    public boolean isLinear() {
        return true;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    static final class Pi {
        private Pi() {
        }

        public static Double pi(int numDigits) {
            int calcDigits = numDigits + 10;
            return 4.0 * (4.0 * Pi.arccot(5.0, calcDigits) - Pi.arccot(239.0, calcDigits));
        }

        private static double arccot(double x, int numDigits) {
            double sum;
            double unity = 1.0;
            double xpower = sum = unity / x;
            Double term = null;
            boolean add = false;
            double n = 3.0;
            while (term == null || !term.equals(0.0)) {
                term = (xpower /= (double)((long)x ^ 2L)) / n;
                sum = add ? sum + term : sum - term;
                add = !add;
                n += 2.0;
            }
            return sum;
        }
    }
}

