/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.spi.SystemOfUnits;
import tec.units.ri.unit.MetricPrefix;

public final class SymbolMap {
    private static final Logger logger = Logger.getLogger(SymbolMap.class.getName());
    private final Map<String, Unit<?>> symbolToUnit = new HashMap();
    private final Map<Unit<?>, String> unitToSymbol = new HashMap();
    private final Map<String, Object> symbolToPrefix = new HashMap<String, Object>();
    private final Map<Object, String> prefixToSymbol = new HashMap<Object, String>();
    private final Map<UnitConverter, MetricPrefix> converterToPrefix = new HashMap<UnitConverter, MetricPrefix>();

    private SymbolMap() {
    }

    private SymbolMap(Map<String, String> map) {
        this();
        for (String fqn : map.keySet()) {
            String symbol = map.get(fqn);
            boolean isAlias = false;
            int lastDot = fqn.lastIndexOf(46);
            String className = fqn.substring(0, lastDot);
            String fieldName = fqn.substring(lastDot + 1, fqn.length());
            if (Character.isDigit(fieldName.charAt(0))) {
                isAlias = true;
                fqn = className;
                lastDot = fqn.lastIndexOf(46);
                className = fqn.substring(0, lastDot);
                fieldName = fqn.substring(lastDot + 1, fqn.length());
            }
            try {
                Class<?> c = Class.forName(className);
                Field field = c.getField(fieldName);
                Object value = field.get(null);
                if (value instanceof Unit) {
                    this.aliasOrLabel((Unit)value, symbol, isAlias);
                    continue;
                }
                if (value instanceof MetricPrefix) {
                    this.label((MetricPrefix)value, symbol);
                    continue;
                }
                throw new ClassCastException("unable to cast " + value + " to Unit or Prefix");
            }
            catch (Exception error) {
                logger.log(Level.SEVERE, "Error", error);
            }
        }
    }

    public static SymbolMap of(Map<String, String> rm) {
        return new SymbolMap(rm);
    }

    public void label(Unit<?> unit, String symbol) {
        this.symbolToUnit.put(symbol, unit);
        this.unitToSymbol.put(unit, symbol);
    }

    public void alias(Unit<?> unit, String symbol) {
        this.symbolToUnit.put(symbol, unit);
    }

    public void label(MetricPrefix prefix, String symbol) {
        this.symbolToPrefix.put(symbol, prefix);
        this.prefixToSymbol.put(prefix, symbol);
        this.converterToPrefix.put(prefix.getConverter(), prefix);
    }

    public Unit<?> getUnit(String symbol) {
        return this.symbolToUnit.get(symbol);
    }

    public String getSymbol(Unit<?> unit) {
        return this.unitToSymbol.get(unit);
    }

    public MetricPrefix getPrefix(String symbol) {
        for (String pfSymbol : this.symbolToPrefix.keySet()) {
            if (!symbol.startsWith(pfSymbol)) continue;
            return (MetricPrefix)this.symbolToPrefix.get(pfSymbol);
        }
        return null;
    }

    public MetricPrefix getPrefix(UnitConverter converter) {
        return this.converterToPrefix.get(converter);
    }

    public String getSymbol(MetricPrefix prefix) {
        return this.prefixToSymbol.get(prefix);
    }

    private void processSOU(SystemOfUnits sou, String symbol, boolean isAlias) {
        for (Unit u : sou.getUnits()) {
            if (!symbol.equals(u.getSymbol())) continue;
            System.out.println(u.getClass().getName() + ": " + symbol);
            this.aliasOrLabel(u, symbol, isAlias);
        }
    }

    private void aliasOrLabel(Unit<?> unit, String symbol, boolean isAlias) {
        if (isAlias) {
            this.alias(unit, symbol);
        } else {
            this.label(unit, symbol);
        }
    }
}

