/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format;

import java.io.IOException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.Parser;
import javax.measure.format.ParserException;
import javax.measure.format.UnitFormat;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.format.EBNFUnitFormat;
import tec.units.ri.format.FormatBehavior;
import tec.units.ri.internal.format.l10n.NumberFormat;
import tec.units.ri.quantity.NumberQuantity;
import tec.units.ri.unit.Units;

public abstract class QuantityFormat
implements Parser<CharSequence, Quantity> {
    private static final NumberSpaceUnit DEFAULT = new NumberSpaceUnit(NumberFormat.getInstance(), EBNFUnitFormat.getInstance());
    private static final Standard STANDARD = new Standard();

    public static QuantityFormat getInstance() {
        return DEFAULT;
    }

    public static QuantityFormat getInstance(FormatBehavior style) {
        switch (style) {
            case LOCALE_NEUTRAL: {
                return STANDARD;
            }
            case LOCALE_SENSITIVE: {
                return DEFAULT;
            }
        }
        return DEFAULT;
    }

    public abstract Appendable format(AbstractQuantity<?> var1, Appendable var2) throws IOException;

    abstract AbstractQuantity<?> parse(CharSequence var1, int var2) throws IllegalArgumentException, ParserException;

    public final StringBuilder format(AbstractQuantity<?> measure, StringBuilder dest) {
        try {
            return (StringBuilder)this.format(measure, (Appendable)dest);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final class Standard
    extends QuantityFormat {
        private Standard() {
        }

        public Appendable format(AbstractQuantity measure, Appendable dest) throws IOException {
            Unit unit = measure.getUnit();
            Number number = measure.getValue();
            dest.append(number.toString());
            if (measure.getUnit().equals(Units.ONE)) {
                return dest;
            }
            dest.append(' ');
            return EBNFUnitFormat.getInstance().format(unit, dest);
        }

        @Override
        AbstractQuantity<?> parse(CharSequence csq, int index) throws ParserException {
            int endDecimal;
            int startDecimal;
            for (startDecimal = index; startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
            }
            for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
            }
            Double decimal = new Double(csq.subSequence(startDecimal, endDecimal).toString());
            Unit<?> unit = EBNFUnitFormat.getInstance().parse(csq, index);
            return NumberQuantity.of(decimal, unit);
        }

        public AbstractQuantity<?> parse(CharSequence csq) throws ParserException {
            return this.parse(csq, 0);
        }
    }

    private static final class NumberSpaceUnit
    extends QuantityFormat {
        private final NumberFormat numberFormat;
        private final UnitFormat unitFormat;

        private NumberSpaceUnit(NumberFormat numberFormat, UnitFormat unitFormat) {
            this.numberFormat = numberFormat;
            this.unitFormat = unitFormat;
        }

        @Override
        public Appendable format(AbstractQuantity<?> quantity, Appendable dest) throws IOException {
            dest.append(this.numberFormat.format(quantity.getValue()));
            if (quantity.getUnit().equals(Units.ONE)) {
                return dest;
            }
            dest.append(' ');
            return this.unitFormat.format(quantity.getUnit(), dest);
        }

        @Override
        AbstractQuantity<?> parse(CharSequence csq, int index) throws IllegalArgumentException, ParserException {
            String str = csq.toString();
            Double number = this.numberFormat.parse(str);
            if (number == null) {
                throw new IllegalArgumentException("Number cannot be parsed");
            }
            Unit unit = this.unitFormat.parse(csq);
            if (number instanceof Long) {
                return NumberQuantity.of(((Number)number).longValue(), unit);
            }
            if (number instanceof Double) {
                return NumberQuantity.of(number, unit);
            }
            if (number instanceof Integer) {
                return NumberQuantity.of(((Number)number).intValue(), unit);
            }
            throw new UnsupportedOperationException("Number of type " + number.getClass() + " are not supported");
        }

        public AbstractQuantity<?> parse(CharSequence csq) throws IllegalArgumentException, ParserException {
            return this.parse(csq, 0);
        }
    }
}

