/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format;

import java.io.IOException;
import java.io.StringReader;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import tec.units.ri.AbstractConverter;
import tec.units.ri.AbstractUnit;
import tec.units.ri.format.AbstractUnitFormat;
import tec.units.ri.format.SymbolMap;
import tec.units.ri.function.AddConverter;
import tec.units.ri.function.ExpConverter;
import tec.units.ri.function.LogConverter;
import tec.units.ri.function.MultiplyConverter;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.internal.format.TokenException;
import tec.units.ri.internal.format.TokenMgrError;
import tec.units.ri.internal.format.UnitFormatParser;
import tec.units.ri.internal.format.l10n.BundleToMapAdapter;
import tec.units.ri.internal.format.l10n.L10nResources;
import tec.units.ri.internal.format.l10n.Locale;
import tec.units.ri.unit.AnnotatedUnit;
import tec.units.ri.unit.BaseUnit;
import tec.units.ri.unit.MetricPrefix;
import tec.units.ri.unit.TransformedUnit;
import tec.units.ri.unit.Units;

public class EBNFUnitFormat
extends AbstractUnitFormat {
    private static final String BUNDLE_NAME = "tec.units.ri.internal.format.Messages";
    private static final EBNFUnitFormat DEFAULT_INSTANCE = new EBNFUnitFormat();
    private static final char MIDDLE_DOT = '\u00b7';
    private static final char EXPONENT_1 = '\u00b9';
    private static final char EXPONENT_2 = '\u00b2';
    private static final int ADDITION_PRECEDENCE = 0;
    private static final int PRODUCT_PRECEDENCE = 2;
    private static final int EXPONENT_PRECEDENCE = 4;
    private static final String LocalFormat_Pattern = "%s";
    private static final int NOOP_PRECEDENCE = Integer.MAX_VALUE;
    private transient SymbolMap symbolMap;

    public static EBNFUnitFormat getInstance() {
        return DEFAULT_INSTANCE;
    }

    protected static EBNFUnitFormat getInstance(SymbolMap symbols, Locale locale) {
        return new EBNFUnitFormat(symbols, locale);
    }

    public EBNFUnitFormat() {
        this(SymbolMap.of(BundleToMapAdapter.toMap(L10nResources.getBundle(BUNDLE_NAME, Locale.getDefault()))), Locale.getDefault());
    }

    private EBNFUnitFormat(SymbolMap symbols, Locale loc) {
        this.symbolMap = symbols;
    }

    @Override
    protected SymbolMap getSymbols() {
        return this.symbolMap;
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        AnnotatedUnit annotatedUnit;
        this.formatInternal(unit, appendable);
        if (unit instanceof AnnotatedUnit && (annotatedUnit = (AnnotatedUnit)unit).getAnnotation() != null) {
            appendable.append('{');
            appendable.append(annotatedUnit.getAnnotation());
            appendable.append('}');
        }
        return appendable;
    }

    @Override
    protected Unit<?> parse(CharSequence csq, int index) throws IllegalArgumentException {
        int start = index;
        int end = csq.length();
        if (end <= start) {
            return Units.ONE;
        }
        String source = csq.subSequence(start, end).toString().trim();
        if (source.length() == 0) {
            return Units.ONE;
        }
        try {
            UnitFormatParser parser = new UnitFormatParser(this.symbolMap, new StringReader(source));
            Unit<?> result = parser.parseUnit();
            return result;
        }
        catch (TokenException e) {
            throw new ParserException((Throwable)((Object)e));
        }
        catch (TokenMgrError e) {
            throw new ParserException((Throwable)e);
        }
    }

    public Unit<?> parse(CharSequence csq) throws ParserException {
        return this.parse(csq, 0);
    }

    private int formatInternal(Unit<?> unit, Appendable buffer) throws IOException {
        String symbol;
        if (unit instanceof AnnotatedUnit) {
            unit = ((AnnotatedUnit)unit).getActualUnit();
        }
        if ((symbol = this.symbolMap.getSymbol(unit)) != null) {
            buffer.append(symbol);
            return Integer.MAX_VALUE;
        }
        if (unit.getProductUnits() != null) {
            int pow;
            Map productUnits = unit.getProductUnits();
            int negativeExponentCount = 0;
            boolean start = true;
            for (Map.Entry e : productUnits.entrySet()) {
                pow = (Integer)e.getValue();
                if (pow >= 0) {
                    this.formatExponent((Unit)e.getKey(), pow, 1, !start, buffer);
                    start = false;
                    continue;
                }
                ++negativeExponentCount;
            }
            if (negativeExponentCount > 0) {
                if (start) {
                    buffer.append('1');
                }
                buffer.append('/');
                if (negativeExponentCount > 1) {
                    buffer.append('(');
                }
                start = true;
                for (Map.Entry e : productUnits.entrySet()) {
                    pow = (Integer)e.getValue();
                    if (pow >= 0) continue;
                    this.formatExponent((Unit)e.getKey(), -pow, 1, !start, buffer);
                    start = false;
                }
                if (negativeExponentCount > 1) {
                    buffer.append(')');
                }
            }
            return 2;
        }
        if (unit instanceof BaseUnit) {
            buffer.append(((BaseUnit)unit).getSymbol());
            return Integer.MAX_VALUE;
        }
        if (unit.getSymbol() != null) {
            buffer.append(unit.getSymbol());
            return Integer.MAX_VALUE;
        }
        UnitConverter converter = null;
        boolean printSeparator = false;
        StringBuilder temp = new StringBuilder();
        int unitPrecedence = Integer.MAX_VALUE;
        Object parentUnit = unit.getSystemUnit();
        converter = ((AbstractUnit)unit).getSystemConverter();
        if (Units.KILOGRAM.equals(parentUnit)) {
            if (unit instanceof TransformedUnit) {
                if (unit.equals(Units.GRAM)) {
                    buffer.append(this.symbolMap.getSymbol(Units.GRAM));
                    return Integer.MAX_VALUE;
                }
                converter = ((TransformedUnit)unit).getConverter();
            } else {
                converter = unit.getConverterTo(Units.GRAM);
            }
        } else if (Units.CUBIC_METRE.equals(parentUnit)) {
            if (converter != null) {
                parentUnit = Units.LITRE;
            }
        } else if (Units.LITRE.equals(parentUnit)) {
            System.out.println(parentUnit);
        }
        if (unit instanceof TransformedUnit) {
            TransformedUnit transUnit = (TransformedUnit)unit;
            if (parentUnit == null) {
                parentUnit = transUnit.getParentUnit();
            }
            converter = transUnit.getConverter();
        }
        unitPrecedence = this.formatInternal((Unit<?>)parentUnit, temp);
        printSeparator = !parentUnit.equals(Units.ONE);
        int result = this.formatConverter(converter, printSeparator, unitPrecedence, temp);
        buffer.append(temp);
        return result;
    }

    private void formatExponent(Unit<?> unit, int pow, int root, boolean continued, Appendable buffer) throws IOException {
        StringBuilder temp;
        int unitPrecedence;
        if (continued) {
            buffer.append('\u00b7');
        }
        if ((unitPrecedence = this.formatInternal(unit, temp = new StringBuilder())) < 2) {
            temp.insert(0, '(');
            temp.append(')');
        }
        buffer.append(temp);
        if (root != 1 || pow != 1) {
            if (root == 1 && pow > 1) {
                String powStr = Integer.toString(pow);
                block12: for (int i = 0; i < powStr.length(); ++i) {
                    char c = powStr.charAt(i);
                    switch (c) {
                        case '0': {
                            buffer.append('\u2070');
                            continue block12;
                        }
                        case '1': {
                            buffer.append('\u00b9');
                            continue block12;
                        }
                        case '2': {
                            buffer.append('\u00b2');
                            continue block12;
                        }
                        case '3': {
                            buffer.append('\u00b3');
                            continue block12;
                        }
                        case '4': {
                            buffer.append('\u2074');
                            continue block12;
                        }
                        case '5': {
                            buffer.append('\u2075');
                            continue block12;
                        }
                        case '6': {
                            buffer.append('\u2076');
                            continue block12;
                        }
                        case '7': {
                            buffer.append('\u2077');
                            continue block12;
                        }
                        case '8': {
                            buffer.append('\u2078');
                            continue block12;
                        }
                        case '9': {
                            buffer.append('\u2079');
                        }
                    }
                }
            } else if (root == 1) {
                buffer.append('^');
                buffer.append(String.valueOf(pow));
            } else {
                buffer.append("^(");
                buffer.append(String.valueOf(pow));
                buffer.append('/');
                buffer.append(String.valueOf(root));
                buffer.append(')');
            }
        }
    }

    private int formatConverter(UnitConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        MetricPrefix prefix = this.symbolMap.getPrefix((AbstractConverter)converter);
        if (prefix != null && unitPrecedence == Integer.MAX_VALUE) {
            buffer.insert(0, this.symbolMap.getSymbol(prefix));
            return Integer.MAX_VALUE;
        }
        if (converter instanceof AddConverter) {
            double offset;
            if (unitPrecedence < 0) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if ((offset = ((AddConverter)converter).getOffset()) < 0.0) {
                buffer.append("-");
                offset = -offset;
            } else if (continued) {
                buffer.append("+");
            }
            long lOffset = (long)offset;
            if ((double)lOffset == offset) {
                buffer.append(lOffset);
            } else {
                buffer.append(offset);
            }
            return 0;
        }
        if (converter instanceof LogConverter) {
            double base = ((LogConverter)converter).getBase();
            StringBuffer expr = new StringBuffer();
            if (base == Math.E) {
                expr.append("ln");
            } else {
                expr.append("log");
                if (base != 10.0) {
                    expr.append((int)base);
                }
            }
            expr.append("(");
            buffer.insert(0, expr);
            buffer.append(")");
            return 4;
        }
        if (converter instanceof ExpConverter) {
            if (unitPrecedence < 4) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            StringBuffer expr = new StringBuffer();
            double base = ((ExpConverter)converter).getBase();
            if (base == Math.E) {
                expr.append('e');
            } else {
                expr.append((int)base);
            }
            expr.append('^');
            buffer.insert(0, expr);
            return 4;
        }
        if (converter instanceof MultiplyConverter) {
            double factor;
            long lFactor;
            if (unitPrecedence < 2) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if (continued) {
                buffer.append('\u00b7');
            }
            if ((double)(lFactor = (long)(factor = ((MultiplyConverter)converter).getFactor())) == factor) {
                buffer.append(lFactor);
            } else {
                buffer.append(factor);
            }
            return 2;
        }
        if (converter instanceof RationalConverter) {
            RationalConverter rationalConverter;
            if (unitPrecedence < 2) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if ((rationalConverter = (RationalConverter)converter).getDividend() != 1.0) {
                if (continued) {
                    buffer.append('\u00b7');
                }
                buffer.append(rationalConverter.getDividend());
            }
            if (rationalConverter.getDivisor() != 1.0) {
                buffer.append('/');
                buffer.append(rationalConverter.getDivisor());
            }
            return 2;
        }
        if (converter instanceof AbstractConverter.Pair) {
            AbstractConverter.Pair compound = (AbstractConverter.Pair)converter;
            if (compound.getLeft() == AbstractConverter.IDENTITY) {
                return this.formatConverter(compound.getRight(), true, unitPrecedence, buffer);
            }
            if (compound.getLeft() instanceof Formattable) {
                return this.formatFormattable((Formattable)compound.getLeft(), unitPrecedence, buffer);
            }
            if (compound.getRight() instanceof Formattable) {
                return this.formatFormattable((Formattable)compound.getRight(), unitPrecedence, buffer);
            }
            return this.formatConverter(compound.getLeft(), true, unitPrecedence, buffer);
        }
        if (converter != null) {
            buffer.replace(0, 1, converter.toString());
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("Unable to format, no UnitConverter given");
    }

    private int formatFormattable(Formattable f, int unitPrecedence, StringBuilder buffer) {
        Formatter fmt = new Formatter();
        fmt.format(LocalFormat_Pattern, f);
        buffer.replace(0, 1, fmt.toString());
        fmt.close();
        return unitPrecedence;
    }
}

