/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.util;

import java.util.Objects;
import tec.units.ri.function.MaximumSupplier;
import tec.units.ri.function.MinimumSupplier;

public abstract class Range<T>
implements MinimumSupplier<T>,
MaximumSupplier<T> {
    private final T min;
    private final T max;

    protected Range(T min, T max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public T getMinimum() {
        return this.min;
    }

    @Override
    public T getMaximum() {
        return this.max;
    }

    public boolean hasMinimum() {
        return this.min != null;
    }

    public boolean hasMaximum() {
        return this.max != null;
    }

    public abstract boolean contains(T var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return Objects.equals(this.getMinimum(), other.getMinimum()) && Objects.equals(this.getMaximum(), other.getMaximum());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("min= ").append(this.getMinimum()).append(", max= ").append(this.getMaximum());
        return sb.toString();
    }
}

