/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.unit;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.units.ri.AbstractUnit;
import tec.units.ri.function.UnitConverterSupplier;

public final class TransformedUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q>
implements UnitConverterSupplier {
    private final AbstractUnit<Q> parentUnit;
    private final UnitConverter converter;
    private String symbol;

    public TransformedUnit(AbstractUnit<Q> parentUnit, UnitConverter toParentUnit) {
        if (!parentUnit.isSystemUnit()) {
            throw new IllegalArgumentException("The parent unit: " + parentUnit + " is not a system unit");
        }
        this.parentUnit = parentUnit;
        this.converter = toParentUnit;
    }

    public TransformedUnit(Unit<Q> parentUnit, UnitConverter toParentUnit) {
        this((AbstractUnit)parentUnit, toParentUnit);
    }

    @Override
    public Dimension getDimension() {
        return this.parentUnit.getDimension();
    }

    @Override
    public UnitConverter getConverterToSI() {
        return this.parentUnit.getConverterToSI().concatenate(this.converter);
    }

    @Override
    public AbstractUnit<Q> toSystemUnit() {
        return this.parentUnit.getSystemUnit();
    }

    @Override
    public Map<? extends Unit<?>, Integer> getProductUnits() {
        return this.parentUnit.getProductUnits();
    }

    @Override
    public int hashCode() {
        return this.parentUnit.hashCode() + this.converter.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof TransformedUnit)) {
            return false;
        }
        TransformedUnit thatUnit = (TransformedUnit)that;
        return this.parentUnit.equals(thatUnit.parentUnit) && this.converter.equals(thatUnit.converter);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Unit<Q> getParentUnit() {
        return this.parentUnit;
    }

    @Override
    public UnitConverter getConverter() {
        return this.converter;
    }
}

