/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.spi;

import java.util.HashMap;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Action;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.DynamicViscosity;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPermittivity;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Information;
import javax.measure.quantity.InformationRate;
import javax.measure.quantity.IonizingRadiation;
import javax.measure.quantity.KinematicViscosity;
import javax.measure.quantity.Length;
import javax.measure.quantity.Luminance;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFieldStrength;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.MagneticPermeability;
import javax.measure.quantity.MagnetomotiveForce;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.quantity.WaveNumber;
import tec.units.ri.AbstractSystemOfUnits;
import tec.units.ri.AbstractUnit;
import tec.units.ri.function.AddConverter;
import tec.units.ri.function.LogConverter;
import tec.units.ri.function.MultiplyConverter;
import tec.units.ri.function.PiMultiplierConverter;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.quantity.QuantityDimension;
import tec.units.ri.unit.AlternateUnit;
import tec.units.ri.unit.BaseUnit;
import tec.units.ri.unit.ProductUnit;
import tec.units.ri.unit.TransformedUnit;

public final class SI
extends AbstractSystemOfUnits {
    private static final SI INSTANCE = new SI();
    private final HashMap<Class<? extends Quantity>, AbstractUnit> quantityToUnit = new HashMap();
    public static final Unit<ElectricCurrent> AMPERE = SI.addUnit(new BaseUnit("A", QuantityDimension.ELECTRIC_CURRENT), ElectricCurrent.class);
    public static final Unit<LuminousIntensity> CANDELA = SI.addUnit(new BaseUnit("cd", QuantityDimension.LUMINOUS_INTENSITY), LuminousIntensity.class);
    public static final Unit<Temperature> KELVIN = SI.addUnit(new BaseUnit("K", QuantityDimension.TEMPERATURE), Temperature.class);
    public static final Unit<Mass> KILOGRAM = SI.addUnit(new BaseUnit("kg", QuantityDimension.MASS), Mass.class);
    public static final Unit<Length> METRE = SI.addUnit(new BaseUnit("m", QuantityDimension.LENGTH), Length.class);
    public static final Unit<AmountOfSubstance> MOLE = SI.addUnit(new BaseUnit("mol", QuantityDimension.AMOUNT_OF_SUBSTANCE), AmountOfSubstance.class);
    public static final Unit<Time> SECOND = SI.addUnit(new BaseUnit("s", QuantityDimension.TIME), Time.class);
    public static final Unit<MagnetomotiveForce> AMPERE_TURN = SI.addUnit(new AlternateUnit(AMPERE, "At"), MagnetomotiveForce.class);
    public static final Unit<Mass> GRAM = SI.addUnit(KILOGRAM.divide(1000.0));
    public static final Unit<Angle> RADIAN = SI.addUnit(new AlternateUnit(AbstractUnit.ONE, "rad"), Angle.class);
    public static final AlternateUnit<SolidAngle> STERADIAN = SI.addUnit(new AlternateUnit(AbstractUnit.ONE, "sr"), SolidAngle.class);
    public static final AlternateUnit<Information> BIT = SI.addUnit(new AlternateUnit(AbstractUnit.ONE, "bit"), Information.class);
    public static final AlternateUnit<Frequency> HERTZ = SI.addUnit(new AlternateUnit(AbstractUnit.ONE.divide(SECOND), "Hz"), Frequency.class);
    public static final Unit<Force> NEWTON = SI.addUnit(new AlternateUnit(METRE.multiply(KILOGRAM).divide(SECOND.pow(2)), "N"), Force.class);
    public static final Unit<Pressure> PASCAL = SI.addUnit(new AlternateUnit(NEWTON.divide(METRE.pow(2)), "Pa"), Pressure.class);
    public static final Unit<Energy> JOULE = SI.addUnit(new AlternateUnit(NEWTON.multiply(METRE), "J"), Energy.class);
    public static final Unit<Power> WATT = SI.addUnit(new AlternateUnit(JOULE.divide(SECOND), "W"), Power.class);
    public static final Unit<ElectricCharge> COULOMB = SI.addUnit(new AlternateUnit(SECOND.multiply(AMPERE), "C"), ElectricCharge.class);
    public static final Unit<ElectricPotential> VOLT = SI.addUnit(new AlternateUnit(WATT.divide(AMPERE), "V"), ElectricPotential.class);
    public static final Unit<ElectricCapacitance> FARAD = SI.addUnit(new AlternateUnit(COULOMB.divide(VOLT), "F"), ElectricCapacitance.class);
    public static final Unit<ElectricResistance> OHM = SI.addUnit(new AlternateUnit(VOLT.divide(AMPERE), "\u03a9"), ElectricResistance.class);
    public static final AlternateUnit<ElectricConductance> SIEMENS = SI.addUnit(new AlternateUnit(AMPERE.divide(VOLT), "S"), ElectricConductance.class);
    public static final AlternateUnit<MagneticFlux> WEBER = SI.addUnit(new AlternateUnit(VOLT.multiply(SECOND), "Wb"), MagneticFlux.class);
    public static final AlternateUnit<MagneticFluxDensity> TESLA = SI.addUnit(new AlternateUnit(WEBER.divide(METRE.pow(2)), "T"), MagneticFluxDensity.class);
    public static final AlternateUnit<ElectricInductance> HENRY = SI.addUnit(new AlternateUnit(WEBER.divide(AMPERE), "H"), ElectricInductance.class);
    public static final Unit<Temperature> CELSIUS = SI.addUnit(new TransformedUnit<Temperature>(KELVIN, (UnitConverter)new AddConverter(273.15)));
    public static final AlternateUnit<LuminousFlux> LUMEN = SI.addUnit(new AlternateUnit(CANDELA.multiply(STERADIAN), "lm"), LuminousFlux.class);
    public static final AlternateUnit<Illuminance> LUX = SI.addUnit(new AlternateUnit(LUMEN.divide(METRE.pow(2)), "lx"), Illuminance.class);
    public static final AlternateUnit<Radioactivity> BECQUEREL = SI.addUnit(new AlternateUnit(AbstractUnit.ONE.divide(SECOND), "Bq"), Radioactivity.class);
    public static final AlternateUnit<RadiationDoseAbsorbed> GRAY = SI.addUnit(new AlternateUnit(JOULE.divide(KILOGRAM), "Gy"), RadiationDoseAbsorbed.class);
    public static final AlternateUnit<RadiationDoseEffective> SIEVERT = SI.addUnit(new AlternateUnit(JOULE.divide(KILOGRAM), "Sv"), RadiationDoseEffective.class);
    public static final AlternateUnit<CatalyticActivity> KATAL = SI.addUnit(new AlternateUnit(MOLE.divide(SECOND), "kat"), CatalyticActivity.class);
    public static final Unit<Speed> METRES_PER_SECOND = SI.addUnit(new ProductUnit(METRE.divide(SECOND)), Speed.class);
    public static final Unit<Acceleration> METRES_PER_SQUARE_SECOND = SI.addUnit(new ProductUnit(METRES_PER_SECOND.divide(SECOND)), Acceleration.class);
    public static final Unit<Area> SQUARE_METRE = SI.addUnit(new ProductUnit(METRE.multiply(METRE)), Area.class);
    public static final Unit<Volume> CUBIC_METRE = SI.addUnit(new ProductUnit(SQUARE_METRE.multiply(METRE)), Volume.class);
    public static final Unit<Action> JOULE_SECOND = SI.addUnit(new ProductUnit(JOULE.multiply(SECOND)), Action.class);
    public static final Unit<ElectricPermittivity> FARADS_PER_METRE = SI.addUnit(new ProductUnit(FARAD.divide(METRE)), ElectricPermittivity.class);
    public static final Unit<MagneticPermeability> NEWTONS_PER_SQUARE_AMPERE = SI.addUnit(new ProductUnit(NEWTON.divide(AMPERE.pow(2))), MagneticPermeability.class);
    public static final Unit<WaveNumber> RECIPROCAL_METRE = SI.addUnit(new ProductUnit(METRE.pow(-1)), WaveNumber.class);
    public static final Unit<DynamicViscosity> PASCAL_SECOND = SI.addUnit(new ProductUnit(PASCAL.multiply(SECOND)), DynamicViscosity.class);
    public static final Unit<Luminance> CANDELAS_PER_SQUARE_METRE = SI.addUnit(new ProductUnit(CANDELA.divide(SQUARE_METRE)), Luminance.class);
    public static final Unit<KinematicViscosity> SQUARE_METRES_PER_SECOND = SI.addUnit(new ProductUnit(SQUARE_METRE.divide(SECOND)), KinematicViscosity.class);
    public static final Unit<MagneticFieldStrength> AMPERES_PER_METRE = SI.addUnit(new ProductUnit(AMPERE.divide(METRE)), MagneticFieldStrength.class);
    public static final Unit<IonizingRadiation> COULOMBS_PER_KILOGRAM = SI.addUnit(new ProductUnit(COULOMB.divide(KILOGRAM)), IonizingRadiation.class);
    public static final Unit<InformationRate> BITS_PER_SECOND = SI.addUnit(new ProductUnit(BIT.divide(SECOND)), InformationRate.class);
    public static final Unit<Dimensionless> PERCENT = new TransformedUnit<Dimensionless>(AbstractUnit.ONE, (UnitConverter)new RationalConverter(1.0, 100.0));
    public static final Unit<Time> MINUTE = new TransformedUnit<Time>(SECOND, (UnitConverter)new RationalConverter(60.0, 1.0));
    public static final Unit<Time> HOUR = new TransformedUnit<Time>(SECOND, (UnitConverter)new RationalConverter(3600.0, 1.0));
    public static final Unit<Time> DAY = new TransformedUnit<Time>(SECOND, (UnitConverter)new RationalConverter(86400.0, 1.0));
    public static final Unit<Angle> DEGREE_ANGLE = new TransformedUnit<Angle>(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate(new RationalConverter(1.0, 180.0)));
    public static final Unit<Angle> MINUTE_ANGLE = new TransformedUnit<Angle>(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate(new RationalConverter(1.0, 10800.0)));
    public static final Unit<Angle> SECOND_ANGLE = new TransformedUnit<Angle>(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate(new RationalConverter(1.0, 648000.0)));
    public static final Unit<Volume> LITRE = new TransformedUnit<Volume>(CUBIC_METRE, (UnitConverter)new RationalConverter(1.0, 1000.0));
    public static final Unit<Mass> TONNE = new TransformedUnit<Mass>(KILOGRAM, (UnitConverter)new RationalConverter(1000.0, 1.0));
    public static final Unit<Dimensionless> NEPER = new TransformedUnit<Dimensionless>(AbstractUnit.ONE, (UnitConverter)new LogConverter(Math.E).inverse());
    public static final Unit<Dimensionless> BEL = new TransformedUnit<Dimensionless>(AbstractUnit.ONE, (UnitConverter)new LogConverter(10.0).inverse());
    public static final Unit<Energy> ELECTRON_VOLT = new TransformedUnit<Energy>(JOULE, (UnitConverter)new MultiplyConverter(1.602176487E-19));
    public static final Unit<Mass> UNIFIED_ATOMIC_MASS = new TransformedUnit<Mass>(KILOGRAM, (UnitConverter)new MultiplyConverter(1.660538782E-27));
    public static final Unit<Length> ASTRONOMICAL_UNIT = SI.addUnit(new TransformedUnit<Length>(METRE, (UnitConverter)new MultiplyConverter(1.49597871E11)));
    public static final Unit<Angle> REVOLUTION = new TransformedUnit<Angle>(RADIAN, (UnitConverter)new PiMultiplierConverter().concatenate(new RationalConverter(2.0, 1.0)));
    public static final Unit<Area> HECTARE = new TransformedUnit<Area>(SQUARE_METRE, (UnitConverter)new RationalConverter(10000.0, 1.0));

    private SI() {
    }

    public static SI getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "SI";
    }

    @Override
    public <Q extends Quantity<Q>> AbstractUnit<Q> getUnit(Class<Q> quantityType) {
        return this.quantityToUnit.get(quantityType);
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        SI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        SI.INSTANCE.units.add(unit);
        SI.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }
}

