/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format.internal.l10n;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.measure.MeasurementException;
import tec.units.ri.format.internal.l10n.L10nBundle;
import tec.units.ri.format.internal.l10n.Locale;

public abstract class L10nResources
implements L10nBundle {
    protected L10nResources parent;

    public static L10nResources getBundle(String baseName, Locale targetLocale) {
        L10nResources parentBundle = null;
        L10nResources bundle = null;
        List<Locale> candidateLocales = L10nResources.getCandidateLocales(targetLocale);
        for (int i = candidateLocales.size() - 1; i >= 0; --i) {
            Locale locale = candidateLocales.get(i);
            String bundleName = baseName + (locale.toString().equals("") ? "" : "_" + locale);
            try {
                Class<?> bundleClass = Class.forName(bundleName);
                bundle = (L10nResources)bundleClass.newInstance();
                bundle.setParent(parentBundle);
                parentBundle = bundle;
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (bundle == null) {
            throw new MeasurementException("Can't find resource bundle for base name " + baseName + ".");
        }
        return bundle;
    }

    private static List<Locale> getCandidateLocales(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        ArrayList<Locale> locales = new ArrayList<Locale>(3);
        if (!country.equals("")) {
            locales.add(locale);
        }
        if (!language.equals("")) {
            locales.add(locales.size() == 0 ? locale : new Locale(language, ""));
        }
        locales.add(Locale.ROOT);
        return locales;
    }

    protected void setParent(L10nResources parent) {
        this.parent = parent;
    }

    @Override
    public final String getString(String key) {
        String string = this.handleGetString(key);
        if (string == null) {
            if (this.parent != null) {
                string = this.parent.getString(key);
            }
            if (string == null) {
                throw new MeasurementException("Can't find resource for bundle " + this.getClass().getName() + " and key " + key + ".");
            }
        }
        return string;
    }

    public abstract Set<String> keySet();

    public abstract Iterator<String> getKeys();

    protected abstract String handleGetString(String var1);
}

