/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format.internal.l10n;

final class DigitList {
    public static final int MAX_COUNT = 19;
    public static final int DBL_DIG = 17;
    public int decimalAt = 0;
    public int count = 0;
    public char[] digits = new char[19];
    private static final char[] LONG_MIN_REP = "9223372036854775808".toCharArray();

    DigitList() {
    }

    public boolean isZero() {
        for (int i = 0; i < this.count; ++i) {
            if (this.digits[i] == '0') continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    public final void set(double source, int maximumFractionDigits) {
        this.set(source, maximumFractionDigits, true);
    }

    final void set(double source, int maximumDigits, boolean fixedPoint) {
        if (source == 0.0) {
            source = 0.0;
        }
        String sourceAsStr = Double.toString(source);
        char[] rep = sourceAsStr.toCharArray();
        int len = rep.length;
        this.decimalAt = -1;
        this.count = 0;
        int exponent = 0;
        int leadingZerosAfterDecimal = 0;
        boolean nonZeroDigitSeen = false;
        int i = 0;
        while (i < len) {
            char c;
            if ((c = rep[i++]) == '.') {
                this.decimalAt = this.count;
                continue;
            }
            if (c == 'e' || c == 'E') {
                exponent = DigitList.parseInt(rep, i);
                break;
            }
            if (this.count >= 19) continue;
            if (!nonZeroDigitSeen) {
                boolean bl = nonZeroDigitSeen = c != '0';
                if (!nonZeroDigitSeen && this.decimalAt != -1) {
                    ++leadingZerosAfterDecimal;
                }
            }
            if (!nonZeroDigitSeen) continue;
            this.digits[this.count++] = c;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        if (nonZeroDigitSeen) {
            this.decimalAt += exponent - leadingZerosAfterDecimal;
        }
        if (fixedPoint) {
            if (-this.decimalAt > maximumDigits) {
                this.count = 0;
                return;
            }
            if (-this.decimalAt == maximumDigits) {
                if (this.shouldRoundUp(0)) {
                    this.count = 1;
                    ++this.decimalAt;
                    this.digits[0] = 49;
                } else {
                    this.count = 0;
                }
                return;
            }
        }
        while (this.count > 1 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        this.round(fixedPoint ? maximumDigits + this.decimalAt : maximumDigits);
    }

    private final void round(int maximumDigits) {
        if (maximumDigits >= 0 && maximumDigits < this.count) {
            if (this.shouldRoundUp(maximumDigits)) {
                do {
                    if (--maximumDigits < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        maximumDigits = 0;
                        break;
                    }
                    int n = maximumDigits;
                    this.digits[n] = (char)(this.digits[n] + '\u0001');
                } while (this.digits[maximumDigits] > '9');
                ++maximumDigits;
            }
            this.count = maximumDigits;
            while (this.count > 1 && this.digits[this.count - 1] == '0') {
                --this.count;
            }
        }
    }

    private boolean shouldRoundUp(int maximumDigits) {
        boolean increment = false;
        if (maximumDigits < this.count) {
            if (this.digits[maximumDigits] > '5') {
                return true;
            }
            if (this.digits[maximumDigits] == '5') {
                for (int i = maximumDigits + 1; i < this.count; ++i) {
                    if (this.digits[i] == '0') continue;
                    return true;
                }
                return maximumDigits > 0 && this.digits[maximumDigits - 1] % 2 != 0;
            }
        }
        return false;
    }

    public final void set(long source, int maximumDigits) {
        if (source <= 0L) {
            if (source == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                System.arraycopy(LONG_MIN_REP, 0, this.digits, 0, this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int left = 19;
            while (source > 0L) {
                this.digits[--left] = (char)(48L + source % 10L);
                source /= 10L;
            }
            this.decimalAt = 19 - left;
            int right = 18;
            while (this.digits[right] == '0') {
                --right;
            }
            this.count = right - left + 1;
            System.arraycopy(this.digits, left, this.digits, 0, this.count);
        }
        if (maximumDigits > 0) {
            this.round(maximumDigits);
        }
    }

    private static final int parseInt(char[] str, int offset) {
        boolean positive = true;
        char c = str[offset];
        if (c == '-') {
            positive = false;
            ++offset;
        } else if (c == '+') {
            ++offset;
        }
        int value = 0;
        while (offset < str.length && (c = str[offset++]) >= '0' && c <= '9') {
            value = value * 10 + (c - 48);
        }
        return positive ? value : -value;
    }
}

