/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.util;

import java.util.Objects;
import tec.units.ri.function.Nameable;

public class TimedData<T>
implements Nameable {
    private final T value;
    private long timestamp;
    private String name;

    protected TimedData(T value, long time) {
        this.value = value;
        this.timestamp = time;
    }

    public static <T> TimedData<T> of(T val, long time) {
        return new TimedData<T>(val, time);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public T get() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TimedData) {
            TimedData other = (TimedData)obj;
            return Objects.equals(this.get(), other.get()) && Objects.equals(this.getTimestamp(), other.getTimestamp()) && Objects.equals(this.getName(), other.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("data= ").append(this.get()).append(", timestamp= ").append(this.getTimestamp());
        if (this.name != null && this.name.length() > 0) {
            sb.append(", name= ").append(this.getName());
        }
        return sb.toString();
    }
}

