/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.util;

import java.util.HashMap;
import javax.measure.Quantity;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.Action;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.DynamicViscosity;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPermittivity;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Information;
import javax.measure.quantity.InformationRate;
import javax.measure.quantity.IonizingRadiation;
import javax.measure.quantity.KinematicViscosity;
import javax.measure.quantity.Length;
import javax.measure.quantity.Luminance;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFieldStrength;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.MagneticPermeability;
import javax.measure.quantity.MagnetomotiveForce;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.quantity.WaveNumber;
import tec.units.ri.AbstractSystemOfUnits;
import tec.units.ri.AbstractUnit;
import tec.units.ri.function.AddConverter;
import tec.units.ri.function.LogConverter;
import tec.units.ri.function.MultiplyConverter;
import tec.units.ri.function.PiMultiplierConverter;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.model.QuantityDimension;
import tec.units.ri.unit.AlternateUnit;
import tec.units.ri.unit.BaseUnit;
import tec.units.ri.unit.ProductUnit;
import tec.units.ri.unit.TransformedUnit;
import tec.units.ri.util.SIPrefix;

public final class SI
extends AbstractSystemOfUnits {
    private static final SI INSTANCE = new SI();
    private final HashMap<Class<? extends Quantity>, AbstractUnit> quantityToUnit = new HashMap();
    public static final BaseUnit<ElectricCurrent> AMPERE = SI.addUnit(new BaseUnit("A", QuantityDimension.ELECTRIC_CURRENT), ElectricCurrent.class);
    public static final BaseUnit<LuminousIntensity> CANDELA = SI.addUnit(new BaseUnit("cd", QuantityDimension.LUMINOUS_INTENSITY), LuminousIntensity.class);
    public static final BaseUnit<Temperature> KELVIN = SI.addUnit(new BaseUnit("K", QuantityDimension.TEMPERATURE), Temperature.class);
    public static final BaseUnit<Mass> KILOGRAM = SI.addUnit(new BaseUnit("kg", QuantityDimension.MASS), Mass.class);
    public static final BaseUnit<Length> METRE = SI.addUnit(new BaseUnit("m", QuantityDimension.LENGTH), Length.class);
    public static final BaseUnit<AmountOfSubstance> MOLE = SI.addUnit(new BaseUnit("mol", QuantityDimension.AMOUNT_OF_SUBSTANCE), AmountOfSubstance.class);
    public static final BaseUnit<Time> SECOND = SI.addUnit(new BaseUnit("s", QuantityDimension.TIME), Time.class);
    public static final AlternateUnit<MagnetomotiveForce> AMPERE_TURN = SI.addUnit(new AlternateUnit(AMPERE, "At"), MagnetomotiveForce.class);
    public static final TransformedUnit<Mass> GRAM = new TransformedUnit<Mass>(KILOGRAM, SIPrefix.KILO.getConverter());
    public static final AlternateUnit<Angle> RADIAN = SI.addUnit(new AlternateUnit(AbstractUnit.ONE, "rad"), Angle.class);
    public static final AlternateUnit<SolidAngle> STERADIAN = SI.addUnit(new AlternateUnit(AbstractUnit.ONE, "sr"), SolidAngle.class);
    public static final AlternateUnit<Information> BIT = SI.addUnit(new AlternateUnit(AbstractUnit.ONE, "bit"), Information.class);
    public static final AlternateUnit<Frequency> HERTZ = SI.addUnit(new AlternateUnit(AbstractUnit.ONE.divide((AbstractUnit<?>)SECOND), "Hz"), Frequency.class);
    public static final AlternateUnit<Force> NEWTON = SI.addUnit(new AlternateUnit(METRE.multiply((AbstractUnit<?>)KILOGRAM).divide((AbstractUnit<?>)SECOND.pow(2)), "N"), Force.class);
    public static final AlternateUnit<Pressure> PASCAL = SI.addUnit(new AlternateUnit(NEWTON.divide((AbstractUnit<?>)METRE.pow(2)), "Pa"), Pressure.class);
    public static final AlternateUnit<Energy> JOULE = SI.addUnit(new AlternateUnit(NEWTON.multiply((AbstractUnit<?>)METRE), "J"), Energy.class);
    public static final AlternateUnit<Power> WATT = SI.addUnit(new AlternateUnit(JOULE.divide((AbstractUnit<?>)SECOND), "W"), Power.class);
    public static final AlternateUnit<ElectricCharge> COULOMB = SI.addUnit(new AlternateUnit(SECOND.multiply((AbstractUnit<?>)AMPERE), "C"), ElectricCharge.class);
    public static final AlternateUnit<ElectricPotential> VOLT = SI.addUnit(new AlternateUnit(WATT.divide((AbstractUnit<?>)AMPERE), "V"), ElectricPotential.class);
    public static final AlternateUnit<ElectricCapacitance> FARAD = SI.addUnit(new AlternateUnit(COULOMB.divide((AbstractUnit<?>)VOLT), "F"), ElectricCapacitance.class);
    public static final AlternateUnit<ElectricResistance> OHM = SI.addUnit(new AlternateUnit(VOLT.divide((AbstractUnit<?>)AMPERE), "\u03a9"), ElectricResistance.class);
    public static final AlternateUnit<ElectricConductance> SIEMENS = SI.addUnit(new AlternateUnit(AMPERE.divide((AbstractUnit<?>)VOLT), "S"), ElectricConductance.class);
    public static final AlternateUnit<MagneticFlux> WEBER = SI.addUnit(new AlternateUnit(VOLT.multiply((AbstractUnit<?>)SECOND), "Wb"), MagneticFlux.class);
    public static final AlternateUnit<MagneticFluxDensity> TESLA = SI.addUnit(new AlternateUnit(WEBER.divide((AbstractUnit<?>)METRE.pow(2)), "T"), MagneticFluxDensity.class);
    public static final AlternateUnit<ElectricInductance> HENRY = SI.addUnit(new AlternateUnit(WEBER.divide((AbstractUnit<?>)AMPERE), "H"), ElectricInductance.class);
    public static final TransformedUnit<Temperature> CELSIUS = SI.addUnit(new TransformedUnit<Temperature>(KELVIN, new AddConverter(273.15)));
    public static final AlternateUnit<LuminousFlux> LUMEN = SI.addUnit(new AlternateUnit(CANDELA.multiply((AbstractUnit<?>)STERADIAN), "lm"), LuminousFlux.class);
    public static final AlternateUnit<Illuminance> LUX = SI.addUnit(new AlternateUnit(LUMEN.divide((AbstractUnit<?>)METRE.pow(2)), "lx"), Illuminance.class);
    public static final AlternateUnit<Radioactivity> BECQUEREL = SI.addUnit(new AlternateUnit(AbstractUnit.ONE.divide((AbstractUnit<?>)SECOND), "Bq"), Radioactivity.class);
    public static final AlternateUnit<RadiationDoseAbsorbed> GRAY = SI.addUnit(new AlternateUnit(JOULE.divide((AbstractUnit<?>)KILOGRAM), "Gy"), RadiationDoseAbsorbed.class);
    public static final AlternateUnit<RadiationDoseEffective> SIEVERT = SI.addUnit(new AlternateUnit(JOULE.divide((AbstractUnit<?>)KILOGRAM), "Sv"), RadiationDoseEffective.class);
    public static final AlternateUnit<CatalyticActivity> KATAL = SI.addUnit(new AlternateUnit(MOLE.divide((AbstractUnit<?>)SECOND), "kat"), CatalyticActivity.class);
    public static final ProductUnit<Speed> METRES_PER_SECOND = SI.addUnit(new ProductUnit(METRE.divide((AbstractUnit<?>)SECOND)), Speed.class);
    public static final ProductUnit<Acceleration> METRES_PER_SQUARE_SECOND = SI.addUnit(new ProductUnit(METRES_PER_SECOND.divide((AbstractUnit<?>)SECOND)), Acceleration.class);
    public static final ProductUnit<Area> SQUARE_METRE = SI.addUnit(new ProductUnit(METRE.multiply((AbstractUnit<?>)METRE)), Area.class);
    public static final ProductUnit<Volume> CUBIC_METRE = SI.addUnit(new ProductUnit(SQUARE_METRE.multiply((AbstractUnit<?>)METRE)), Volume.class);
    public static final ProductUnit<Action> JOULE_SECOND = SI.addUnit(new ProductUnit(JOULE.multiply((AbstractUnit<?>)SECOND)), Action.class);
    public static final ProductUnit<ElectricPermittivity> FARADS_PER_METRE = SI.addUnit(new ProductUnit(FARAD.divide((AbstractUnit<?>)METRE)), ElectricPermittivity.class);
    public static final ProductUnit<MagneticPermeability> NEWTONS_PER_SQUARE_AMPERE = SI.addUnit(new ProductUnit(NEWTON.divide((AbstractUnit<?>)AMPERE.pow(2))), MagneticPermeability.class);
    public static final ProductUnit<WaveNumber> RECIPROCAL_METRE = SI.addUnit(new ProductUnit((AbstractUnit<?>)METRE.pow(-1)), WaveNumber.class);
    public static final ProductUnit<DynamicViscosity> PASCAL_SECOND = SI.addUnit(new ProductUnit(PASCAL.multiply((AbstractUnit<?>)SECOND)), DynamicViscosity.class);
    public static final ProductUnit<Luminance> CANDELAS_PER_SQUARE_METRE = SI.addUnit(new ProductUnit(CANDELA.divide((AbstractUnit<?>)SQUARE_METRE)), Luminance.class);
    public static final ProductUnit<KinematicViscosity> SQUARE_METRES_PER_SECOND = SI.addUnit(new ProductUnit(SQUARE_METRE.divide((AbstractUnit<?>)SECOND)), KinematicViscosity.class);
    public static final ProductUnit<MagneticFieldStrength> AMPERES_PER_METRE = SI.addUnit(new ProductUnit(AMPERE.divide((AbstractUnit<?>)METRE)), MagneticFieldStrength.class);
    public static final ProductUnit<IonizingRadiation> COULOMBS_PER_KILOGRAM = SI.addUnit(new ProductUnit(COULOMB.divide((AbstractUnit<?>)KILOGRAM)), IonizingRadiation.class);
    public static final ProductUnit<InformationRate> BITS_PER_SECOND = SI.addUnit(new ProductUnit(BIT.divide((AbstractUnit<?>)SECOND)), InformationRate.class);
    public static final TransformedUnit<Dimensionless> PERCENT = new TransformedUnit<Dimensionless>(AbstractUnit.ONE, new RationalConverter(1L, 100L));
    public static final TransformedUnit<Time> MINUTE = new TransformedUnit<Time>(SECOND, new RationalConverter(60L, 1L));
    public static final TransformedUnit<Time> HOUR = new TransformedUnit<Time>(SECOND, new RationalConverter(3600L, 1L));
    public static final TransformedUnit<Time> DAY = new TransformedUnit<Time>(SECOND, new RationalConverter(86400L, 1L));
    public static final TransformedUnit<Angle> DEGREE_ANGLE = new TransformedUnit<Angle>(RADIAN, new PiMultiplierConverter().concatenate(new RationalConverter(1L, 180L)));
    public static final TransformedUnit<Angle> MINUTE_ANGLE = new TransformedUnit<Angle>(RADIAN, new PiMultiplierConverter().concatenate(new RationalConverter(1L, 10800L)));
    public static final TransformedUnit<Angle> SECOND_ANGLE = new TransformedUnit<Angle>(RADIAN, new PiMultiplierConverter().concatenate(new RationalConverter(1L, 648000L)));
    public static final TransformedUnit<Volume> LITRE = new TransformedUnit<Volume>(CUBIC_METRE, new RationalConverter(1L, 1000L));
    public static final TransformedUnit<Mass> TONNE = new TransformedUnit<Mass>(KILOGRAM, new RationalConverter(1000L, 1L));
    public static final TransformedUnit<Dimensionless> NEPER = new TransformedUnit<Dimensionless>(AbstractUnit.ONE, new LogConverter(Math.E).inverse());
    public static final TransformedUnit<Dimensionless> BEL = new TransformedUnit<Dimensionless>(AbstractUnit.ONE, new LogConverter(10.0).inverse());
    public static final TransformedUnit<Energy> ELECTRON_VOLT = new TransformedUnit<Energy>(JOULE, new MultiplyConverter(1.602176487E-19));
    public static final TransformedUnit<Mass> UNIFIED_ATOMIC_MASS = new TransformedUnit<Mass>(KILOGRAM, new MultiplyConverter(1.660538782E-27));
    public static final TransformedUnit<Length> ASTRONOMICAL_UNIT = new TransformedUnit<Length>(METRE, new MultiplyConverter(1.49597871E11));
    public static final TransformedUnit<Angle> REVOLUTION = new TransformedUnit<Angle>(RADIAN, new PiMultiplierConverter().concatenate(new RationalConverter(2L, 1L)));
    public static final TransformedUnit<Area> HECTARE = new TransformedUnit<Area>(SQUARE_METRE, new RationalConverter(10000L, 1L));

    private SI() {
    }

    public static SI getInstance() {
        return INSTANCE;
    }

    @Override
    public String getName() {
        return "SI";
    }

    @Override
    public <Q extends Quantity<Q>> AbstractUnit<Q> getUnit(Class<Q> quantityType) {
        return this.quantityToUnit.get(quantityType);
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit) {
        SI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends AbstractUnit<?>> U addUnit(U unit, Class<? extends Quantity<?>> type) {
        SI.INSTANCE.units.add(unit);
        SI.INSTANCE.quantityToUnit.put(type, unit);
        return unit;
    }
}

