/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.util;

import java.util.Objects;
import javax.measure.Quantity;
import tec.units.ri.util.Range;

public class QuantityRange<Q extends Quantity<Q>>
extends Range<Quantity<Q>> {
    private Quantity<Q> res;

    protected QuantityRange(Quantity<Q> min, Quantity<Q> max, Quantity<Q> resolution) {
        super(min, max);
        this.res = resolution;
    }

    protected QuantityRange(Quantity<Q> min, Quantity<Q> max) {
        super(min, max);
    }

    public static QuantityRange of(Quantity minimum, Quantity maximum, Quantity resolution) {
        return new QuantityRange(minimum, maximum, resolution);
    }

    public Quantity<Q> getResolution() {
        return this.res;
    }

    @Override
    public boolean contains(Quantity<Q> q) {
        return q.getValue().doubleValue() >= ((Quantity)this.getMinimum()).getValue().doubleValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuantityRange) {
            QuantityRange other = (QuantityRange)obj;
            return Objects.equals(this.getMinimum(), other.getMinimum()) && Objects.equals(this.getMaximum(), other.getMaximum()) && Objects.equals(this.getResolution(), other.getResolution());
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append("min= ").append(this.getMinimum()).append(", max= ").append(this.getMaximum());
        if (this.res != null) {
            sb.append(", res= ").append(this.getResolution());
        }
        return sb.toString();
    }
}

