/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.function;

import javax.measure.UnitConverter;
import tec.units.ri.AbstractConverter;
import tec.units.ri.function.MathHelper;
import tec.units.ri.function.ValueSupplier;

public final class RationalConverter
extends AbstractConverter
implements ValueSupplier<Double> {
    private final long dividend;
    private final long divisor;

    public RationalConverter(long dividend, long divisor) {
        this.dividend = dividend;
        this.divisor = divisor;
    }

    public long getDividend() {
        return this.dividend;
    }

    public long getDivisor() {
        return this.divisor;
    }

    @Override
    public double convert(double value) {
        return value * ((double)this.dividend / (double)this.divisor);
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (!(converter instanceof RationalConverter)) {
            return super.concatenate(converter);
        }
        RationalConverter that = (RationalConverter)converter;
        long newDividend = this.getDividend() * that.getDividend();
        long newDivisor = this.getDivisor() * that.getDivisor();
        long gcd = MathHelper.gcd(newDividend, newDivisor);
        return (newDividend /= gcd) == 1L && newDivisor == 1L ? IDENTITY : new RationalConverter(newDividend, newDivisor /= gcd);
    }

    @Override
    public RationalConverter inverse() {
        return Math.signum((double)this.dividend) == -1.0 ? new RationalConverter(MathHelper.negateExact(this.getDivisor()), MathHelper.negateExact(this.getDividend())) : new RationalConverter(this.getDivisor(), this.getDividend());
    }

    public final String toString() {
        return "RationalConverter(" + this.dividend + "," + this.divisor + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RationalConverter)) {
            return false;
        }
        RationalConverter that = (RationalConverter)obj;
        return this.dividend == that.dividend && this.divisor == that.divisor;
    }

    @Override
    public int hashCode() {
        return Long.valueOf(this.dividend).hashCode() + Long.valueOf(this.dividend).hashCode();
    }

    public boolean isLinear() {
        return true;
    }

    @Override
    public Double getValue() {
        return (double)this.dividend / (double)this.divisor;
    }
}

