/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.Parser;
import javax.measure.format.ParserException;
import javax.measure.format.UnitFormat;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.AbstractUnit;
import tec.units.ri.format.FormatBehavior;
import tec.units.ri.format.LocalUnitFormat;
import tec.units.ri.quantity.NumberQuantity;

public abstract class QuantityFormat
extends Format
implements Parser<CharSequence, Quantity> {
    private static final long serialVersionUID = -4628006924354248662L;
    private static final NumberSpaceUnit DEFAULT = new NumberSpaceUnit(NumberFormat.getInstance(), LocalUnitFormat.getInstance());
    private static final Standard STANDARD = new Standard();

    public static QuantityFormat getInstance() {
        return DEFAULT;
    }

    public static QuantityFormat getInstance(FormatBehavior style) {
        switch (style) {
            case LOCALE_NEUTRAL: {
                return STANDARD;
            }
            case LOCALE_SENSITIVE: {
                return DEFAULT;
            }
        }
        return DEFAULT;
    }

    public abstract Appendable format(AbstractQuantity<?> var1, Appendable var2) throws IOException;

    public abstract AbstractQuantity<?> parse(CharSequence var1, ParsePosition var2) throws IllegalArgumentException, ParserException;

    public abstract AbstractQuantity<?> parse(CharSequence var1) throws IllegalArgumentException, ParserException;

    @Override
    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof AbstractQuantity)) {
            throw new IllegalArgumentException("obj: Not an instance of Measure");
        }
        if (toAppendTo == null || pos == null) {
            throw new NullPointerException();
        }
        try {
            return (StringBuffer)this.format((AbstractQuantity)obj, toAppendTo);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    @Override
    public final AbstractQuantity<?> parseObject(String source, ParsePosition pos) {
        try {
            return this.parse(source, pos);
        }
        catch (IllegalArgumentException | ParserException e) {
            return null;
        }
    }

    public final StringBuilder format(AbstractQuantity<?> measure, StringBuilder dest) {
        try {
            return (StringBuilder)this.format(measure, (Appendable)dest);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final class Standard
    extends QuantityFormat {
        private static final long serialVersionUID = 2758248665095734058L;

        private Standard() {
        }

        public Appendable format(AbstractQuantity measure, Appendable dest) throws IOException {
            Unit unit = measure.getUnit();
            Number number = measure.getValue();
            dest.append(number.toString());
            if (measure.getUnit().equals(AbstractUnit.ONE)) {
                return dest;
            }
            dest.append(' ');
            return LocalUnitFormat.getInstance().format(unit, dest);
        }

        @Override
        public AbstractQuantity<?> parse(CharSequence csq, ParsePosition cursor) throws ParserException {
            int endDecimal;
            int startDecimal;
            for (startDecimal = cursor.getIndex(); startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
            }
            for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
            }
            Double decimal = new Double(csq.subSequence(startDecimal, endDecimal).toString());
            cursor.setIndex(endDecimal + 1);
            AbstractUnit<?> unit = LocalUnitFormat.getInstance().parse(csq, cursor);
            return NumberQuantity.of(decimal, unit);
        }

        @Override
        public AbstractQuantity<?> parse(CharSequence csq) throws ParserException {
            return this.parse(csq, new ParsePosition(0));
        }
    }

    private static final class NumberSpaceUnit
    extends QuantityFormat {
        private final NumberFormat numberFormat;
        private final UnitFormat unitFormat;
        private static final long serialVersionUID = 1L;

        private NumberSpaceUnit(NumberFormat numberFormat, UnitFormat unitFormat) {
            this.numberFormat = numberFormat;
            this.unitFormat = unitFormat;
        }

        @Override
        public Appendable format(AbstractQuantity<?> quantity, Appendable dest) throws IOException {
            dest.append(this.numberFormat.format(quantity.getValue()));
            if (quantity.getUnit().equals(AbstractUnit.ONE)) {
                return dest;
            }
            dest.append(' ');
            return this.unitFormat.format(quantity.getUnit(), dest);
        }

        @Override
        public AbstractQuantity<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException, ParserException {
            String str = csq.toString();
            Number number = this.numberFormat.parse(str, cursor);
            if (number == null) {
                throw new IllegalArgumentException("Number cannot be parsed");
            }
            Unit unit = this.unitFormat.parse(csq);
            if (number instanceof Long) {
                return NumberQuantity.of(number.longValue(), unit);
            }
            if (number instanceof Double) {
                return NumberQuantity.of(number.doubleValue(), unit);
            }
            if (number instanceof Integer) {
                return NumberQuantity.of(number.intValue(), unit);
            }
            throw new UnsupportedOperationException("Number of type " + number.getClass() + " are not supported");
        }

        @Override
        public AbstractQuantity<?> parse(CharSequence csq) throws IllegalArgumentException, ParserException {
            return this.parse(csq, new ParsePosition(0));
        }
    }
}

