/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.ParserException;
import javax.measure.format.UnitFormat;
import javax.measure.quantity.Mass;
import tec.units.ri.AbstractUnit;
import tec.units.ri.format.SymbolMap;
import tec.units.ri.format.internal.ParseException;
import tec.units.ri.format.internal.TokenMgrError;
import tec.units.ri.format.internal.UnitParser;
import tec.units.ri.function.AddConverter;
import tec.units.ri.function.MultiplyConverter;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.unit.AlternateUnit;
import tec.units.ri.unit.AnnotatedUnit;
import tec.units.ri.unit.BaseUnit;
import tec.units.ri.unit.TransformedUnit;
import tec.units.ri.util.SI;
import tec.units.ri.util.SIPrefix;
import tec.units.ri.util.UCUM;

public class LocalUnitFormat
implements UnitFormat {
    private static LocalUnitFormat DEFAULT_INSTANCE = new LocalUnitFormat(SymbolMap.of(ResourceBundle.getBundle(LocalUnitFormat.class.getPackage().getName() + ".messages")));
    private static final char MIDDLE_DOT = '\u00b7';
    private static final int ADDITION_PRECEDENCE = 0;
    private static final int PRODUCT_PRECEDENCE = 2;
    private static final int EXPONENT_PRECEDENCE = 4;
    private static final int NOOP_PRECEDENCE = Integer.MAX_VALUE;
    private transient SymbolMap symbolMap;

    public static LocalUnitFormat getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static LocalUnitFormat getInstance(Locale locale) {
        return new LocalUnitFormat(SymbolMap.of(ResourceBundle.getBundle(LocalUnitFormat.class.getName(), locale)));
    }

    public static LocalUnitFormat getInstance(SymbolMap symbols) {
        return new LocalUnitFormat(symbols);
    }

    private LocalUnitFormat(SymbolMap symbols) {
        this.symbolMap = symbols;
    }

    SymbolMap getSymbols() {
        return this.symbolMap;
    }

    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        if (!(unit instanceof AbstractUnit)) {
            return appendable.append(unit.toString());
        }
        this.formatInternal((AbstractUnit)unit, appendable);
        return appendable;
    }

    public AbstractUnit<?> parse(CharSequence csq, ParsePosition cursor) throws ParserException {
        int start = cursor.getIndex();
        int end = csq.length();
        if (end <= start) {
            return AbstractUnit.ONE;
        }
        String source = csq.subSequence(start, end).toString().trim();
        if (source.length() == 0) {
            return AbstractUnit.ONE;
        }
        try {
            UnitParser parser = new UnitParser(this.symbolMap, new StringReader(source));
            AbstractUnit result = parser.parseUnit();
            cursor.setIndex(end);
            return result;
        }
        catch (ParseException e) {
            if (e.currentToken != null) {
                cursor.setErrorIndex(start + e.currentToken.endColumn);
            } else {
                cursor.setErrorIndex(start);
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (TokenMgrError e) {
            cursor.setErrorIndex(start);
            throw new ParserException((Throwable)e);
        }
    }

    public AbstractUnit<? extends Quantity> parse(CharSequence csq) throws ParserException {
        return this.parse(csq, new ParsePosition(0));
    }

    private int formatInternal(Unit<?> unit, Appendable buffer) throws IOException {
        String symbol;
        if (unit instanceof AnnotatedUnit) {
            unit = ((AnnotatedUnit)unit).getActualUnit();
        }
        if ((symbol = this.symbolMap.getSymbol((AbstractUnit)unit)) != null) {
            buffer.append(symbol);
            return Integer.MAX_VALUE;
        }
        if (unit.getProductUnits() != null) {
            int pow;
            Map productUnits = unit.getProductUnits();
            int negativeExponentCount = 0;
            boolean start = true;
            for (Map.Entry e : productUnits.entrySet()) {
                pow = (Integer)e.getValue();
                if (pow >= 0) {
                    this.formatExponent((Unit)e.getKey(), pow, 1, !start, buffer);
                    start = false;
                    continue;
                }
                ++negativeExponentCount;
            }
            if (negativeExponentCount > 0) {
                if (start) {
                    buffer.append('1');
                }
                buffer.append('/');
                if (negativeExponentCount > 1) {
                    buffer.append('(');
                }
                start = true;
                for (Map.Entry e : productUnits.entrySet()) {
                    pow = (Integer)e.getValue();
                    if (pow >= 0) continue;
                    this.formatExponent((Unit)e.getKey(), -pow, 1, !start, buffer);
                    start = false;
                }
                if (negativeExponentCount > 1) {
                    buffer.append(')');
                }
            }
            return 2;
        }
        if (unit instanceof BaseUnit) {
            buffer.append(((BaseUnit)unit).getSymbol());
            return Integer.MAX_VALUE;
        }
        if (unit instanceof AlternateUnit) {
            buffer.append(unit.getSymbol());
            return Integer.MAX_VALUE;
        }
        UnitConverter converter = null;
        boolean printSeparator = false;
        StringBuilder temp = new StringBuilder();
        int unitPrecedence = Integer.MAX_VALUE;
        TransformedUnit<Mass> parentUnit = unit.getSystemUnit();
        converter = ((AbstractUnit)unit).getConverterToSI();
        if (SI.KILOGRAM.equals(parentUnit)) {
            if (unit.equals(SI.GRAM)) {
                buffer.append(this.symbolMap.getSymbol(SI.GRAM));
                return Integer.MAX_VALUE;
            }
            parentUnit = SI.GRAM;
            converter = unit instanceof TransformedUnit ? ((TransformedUnit)unit).getConverter() : unit.getConverterTo(SI.GRAM);
        } else if (SI.CUBIC_METRE.equals(parentUnit) && converter != null) {
            parentUnit = UCUM.LITER;
        }
        if (unit instanceof TransformedUnit) {
            TransformedUnit transUnit = (TransformedUnit)unit;
            if (parentUnit == null) {
                parentUnit = transUnit.getParentUnit();
            }
            converter = transUnit.getConverter();
        }
        unitPrecedence = this.formatInternal(parentUnit, temp);
        printSeparator = !((Object)parentUnit).equals(AbstractUnit.ONE);
        int result = this.formatConverter(converter, printSeparator, unitPrecedence, temp);
        buffer.append(temp);
        return result;
    }

    private void formatExponent(Unit<?> unit, int pow, int root, boolean continued, Appendable buffer) throws IOException {
        StringBuffer temp;
        int unitPrecedence;
        if (continued) {
            buffer.append('\u00b7');
        }
        if ((unitPrecedence = this.formatInternal(unit, temp = new StringBuffer())) < 2) {
            temp.insert(0, '(');
            temp.append(')');
        }
        buffer.append(temp);
        if (root != 1 || pow != 1) {
            if (root == 1 && pow > 1) {
                String powStr = Integer.toString(pow);
                block12: for (int i = 0; i < powStr.length(); ++i) {
                    char c = powStr.charAt(i);
                    switch (c) {
                        case '0': {
                            buffer.append('\u2070');
                            continue block12;
                        }
                        case '1': {
                            buffer.append('\u00b9');
                            continue block12;
                        }
                        case '2': {
                            buffer.append('\u00b2');
                            continue block12;
                        }
                        case '3': {
                            buffer.append('\u00b3');
                            continue block12;
                        }
                        case '4': {
                            buffer.append('\u2074');
                            continue block12;
                        }
                        case '5': {
                            buffer.append('\u2075');
                            continue block12;
                        }
                        case '6': {
                            buffer.append('\u2076');
                            continue block12;
                        }
                        case '7': {
                            buffer.append('\u2077');
                            continue block12;
                        }
                        case '8': {
                            buffer.append('\u2078');
                            continue block12;
                        }
                        case '9': {
                            buffer.append('\u2079');
                        }
                    }
                }
            } else if (root == 1) {
                buffer.append("^");
                buffer.append(String.valueOf(pow));
            } else {
                buffer.append("^(");
                buffer.append(String.valueOf(pow));
                buffer.append('/');
                buffer.append(String.valueOf(root));
                buffer.append(')');
            }
        }
    }

    private int formatConverter(UnitConverter converter, boolean continued, int unitPrecedence, StringBuilder buffer) {
        SIPrefix prefix = this.symbolMap.getPrefix(converter);
        if (prefix != null && unitPrecedence == Integer.MAX_VALUE) {
            buffer.insert(0, this.symbolMap.getSymbol(prefix));
            return Integer.MAX_VALUE;
        }
        if (converter instanceof AddConverter) {
            double offset;
            if (unitPrecedence < 0) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if ((offset = ((AddConverter)converter).getOffset()) < 0.0) {
                buffer.append("-");
                offset = -offset;
            } else if (continued) {
                buffer.append("+");
            }
            long lOffset = (long)offset;
            if ((double)lOffset == offset) {
                buffer.append(lOffset);
            } else {
                buffer.append(offset);
            }
            return 0;
        }
        if (converter instanceof MultiplyConverter) {
            double factor;
            long lFactor;
            if (unitPrecedence < 2) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if (continued) {
                buffer.append('\u00b7');
            }
            if ((double)(lFactor = (long)(factor = ((MultiplyConverter)converter).getFactor())) == factor) {
                buffer.append(lFactor);
            } else {
                buffer.append(factor);
            }
            return 2;
        }
        if (converter instanceof RationalConverter) {
            RationalConverter rationalConverter;
            if (unitPrecedence < 2) {
                buffer.insert(0, '(');
                buffer.append(')');
            }
            if ((rationalConverter = (RationalConverter)converter).getDividend() != 1L) {
                if (continued) {
                    buffer.append('\u00b7');
                }
                buffer.append(rationalConverter.getDividend());
            }
            if (rationalConverter.getDivisor() != 1L) {
                buffer.append('/');
                buffer.append(rationalConverter.getDivisor());
            }
            return 2;
        }
        buffer.insert(0, converter.toString() + "(");
        buffer.append(")");
        return 4;
    }
}

