/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.SystemOfUnits;
import tec.units.ri.AbstractUnit;

public abstract class AbstractSystemOfUnits
implements SystemOfUnits {
    protected final Set<Unit<?>> units = new HashSet();
    protected final Map<Class<? extends Quantity>, AbstractUnit> quantityToUnit = new HashMap<Class<? extends Quantity>, AbstractUnit>();
    protected static final double E = Math.E;

    public abstract String getName();

    public Set<Unit<?>> getUnits() {
        return Collections.unmodifiableSet(this.units);
    }

    public Set<? extends Unit<?>> getUnits(Dimension dimension) {
        HashSet set = new HashSet();
        for (Unit<?> unit : this.getUnits()) {
            if (!dimension.equals(unit.getDimension())) continue;
            set.add(unit);
        }
        return set;
    }

    public <Q extends Quantity<Q>> AbstractUnit<Q> getUnit(Class<Q> quantityType) {
        return this.quantityToUnit.get(quantityType);
    }

    static class Helper {
        Helper() {
        }

        static Set<Unit<?>> getUnitsOfDimension(Set<Unit<?>> units, Dimension dimension) {
            if (dimension != null) {
                HashSet dimSet = new HashSet();
                for (Unit<?> u : units) {
                    if (!dimension.equals(u.getDimension())) continue;
                    dimSet.add(u);
                }
                return dimSet;
            }
            return null;
        }
    }
}

