/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.util;

import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Information;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.SystemOfUnits;
import tec.units.ri.AbstractSystemOfUnits;
import tec.units.ri.AbstractUnit;
import tec.units.ri.function.RationalConverter;
import tec.units.ri.unit.ProductUnit;
import tec.units.ri.unit.TransformedUnit;
import tec.units.ri.util.SI;
import tec.units.ri.util.SIPrefix;

public final class US
extends AbstractSystemOfUnits {
    private static final US INSTANCE = new US();
    public static final Unit<Length> METER = SI.METRE;
    public static final Unit<Length> FOOT = US.addUnit(METER.multiply(3048.0).divide(10000.0));
    public static final Unit<Length> FOOT_SURVEY = US.addUnit(METER.multiply(1200.0).divide(3937.0));
    public static final Unit<Length> YARD = US.addUnit(FOOT.multiply(3.0));
    public static final Unit<Length> INCH = US.addUnit(FOOT.divide(12.0));
    public static final Unit<Length> MILE = US.addUnit(METER.multiply(1609344.0).divide(1000.0));
    public static final Unit<Length> LIGHT_YEAR = US.addUnit(SI.METRE.multiply(9.460528405E15));
    public static final Unit<Length> NAUTICAL_MILE = US.addUnit(METER.multiply(1852.0));
    public static final Unit<Mass> POUND = US.addUnit(SI.KILOGRAM.multiply(4.5359237E7).divide(1.0E8));
    public static final Unit<Mass> OUNCE = US.addUnit(POUND.divide(16.0));
    public static final Unit<Mass> TON = US.addUnit(POUND.multiply(2000.0));
    public static final Unit<Temperature> RANKINE = US.addUnit(SI.KELVIN.multiply(5.0).divide(9.0));
    public static final Unit<Temperature> FAHRENHEIT = US.addUnit(RANKINE.shift(459.67));
    public static final Unit<Angle> REVOLUTION = US.addUnit(SI.RADIAN.multiply(2.0).multiply(Math.PI).asType(Angle.class));
    public static final Unit<Angle> DEGREE_ANGLE = US.addUnit(REVOLUTION.divide(360.0));
    public static final Unit<Angle> MINUTE_ANGLE = US.addUnit(DEGREE_ANGLE.divide(60.0));
    public static final Unit<Angle> SECOND_ANGLE = US.addUnit(MINUTE_ANGLE.divide(60.0));
    public static final Unit<Angle> CENTIRADIAN = US.addUnit(SI.RADIAN.divide(100.0));
    public static final Unit<Angle> GRADE = US.addUnit(REVOLUTION.divide(400.0));
    public static final Unit<Time> MINUTE = US.addUnit(SI.SECOND.multiply(60.0));
    public static final Unit<Time> HOUR = US.addUnit(MINUTE.multiply(60.0));
    public static final Unit<Speed> FEET_PER_SECOND = US.addUnit(FOOT.divide(SI.SECOND)).asType(Speed.class);
    public static final Unit<Speed> MILES_PER_HOUR = US.addUnit(MILE.divide(HOUR)).asType(Speed.class);
    public static final Unit<Speed> KNOT = US.addUnit(NAUTICAL_MILE.divide(HOUR)).asType(Speed.class);
    public static final Unit<Area> SQUARE_FOOT = US.addUnit(new ProductUnit((AbstractUnit)FOOT.multiply(FOOT)));
    public static final Unit<Area> ARE = US.addUnit(SI.SQUARE_METRE.multiply(100.0));
    public static final Unit<Area> HECTARE = US.addUnit(ARE.multiply(100.0));
    public static final Unit<Area> ACRE = US.addUnit(SQUARE_FOOT.multiply(43560.0));
    public static final Unit<Information> BYTE = US.addUnit(SI.BIT.multiply(8.0));
    public static final Unit<Information> OCTET = BYTE;
    public static final Unit<Energy> ELECTRON_VOLT = US.addUnit(SI.JOULE.multiply(1.602176462E-19));
    public static final Unit<Power> HORSEPOWER = US.addUnit(SI.WATT.multiply(735.499));
    public static final TransformedUnit<Volume> LITER = new TransformedUnit<Volume>(SI.CUBIC_METRE, new RationalConverter(1.0, 1000.0));
    public static final Unit<Volume> CUBIC_INCH = US.addUnit(INCH.pow(3).asType(Volume.class));
    public static final Unit<Volume> GALLON_DRY = US.addUnit(CUBIC_INCH.multiply(2688025.0).divide(10000.0));
    public static final Unit<Volume> GALLON_LIQUID = US.addUnit(CUBIC_INCH.multiply(231.0));
    public static final Unit<Volume> OUNCE_LIQUID = US.addUnit(GALLON_LIQUID.divide(128.0));
    public static final Unit<Volume> MINIM = US.addUnit(SIPrefix.MICRO(LITER).multiply(61.61152));
    public static final Unit<Volume> FLUID_DRAM = US.addUnit(MINIM.multiply(60.0));
    public static final Unit<Volume> TEASPOON = US.addUnit(MINIM.multiply(80.0));
    public static final Unit<Volume> TABLESPOON = US.addUnit(TEASPOON.multiply(3.0));
    public static final Unit<Volume> BARREL = US.addUnit(LITER.multiply(238.481));

    private US() {
    }

    public static SystemOfUnits getInstance() {
        return INSTANCE;
    }

    protected static <U extends Unit<?>> U addUnit(U unit) {
        US.INSTANCE.units.add(unit);
        return unit;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }
}

